/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.google.common.hash.Hashing;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.SparkCreateSimRels;
import eu.dnetlib.dhp.oa.dedup.graph.ConnectedComponent;
import eu.dnetlib.dhp.oa.dedup.graph.GraphProcessor;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.graphx.Edge;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCreateMergeRels
extends AbstractSparkAction {
    public static final String PROVENANCE_ACTION_CLASS = "sysimport:dedup";
    private static final Logger log = LoggerFactory.getLogger(SparkCreateMergeRels.class);
    public static final String DNET_PROVENANCE_ACTIONS = "dnet:provenanceActions";

    public SparkCreateMergeRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/createCC_parameters.json")));
        parser.parseArgument(args);
        String isLookUpUrl = parser.get("isLookUpUrl");
        log.info("isLookupUrl {}", (Object)isLookUpUrl);
        SparkConf conf = new SparkConf();
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ModelSupport.getOafModelClasses());
        new SparkCreateMergeRels(parser, SparkCreateMergeRels.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)isLookUpUrl));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws ISLookUpException, DocumentException, IOException {
        String graphBasePath = this.parser.get("graphBasePath");
        String workingPath = this.parser.get("workingPath");
        String isLookUpUrl = this.parser.get("isLookUpUrl");
        String actionSetId = this.parser.get("actionSetId");
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("isLookUpUrl:   '{}'", (Object)isLookUpUrl);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)this.spark.sparkContext());
        for (DedupConfig dedupConf : this.getConfigurations(isLookUpService, actionSetId)) {
            String subEntity = dedupConf.getWf().getSubEntityValue();
            log.info("Creating mergerels for: '{}'", (Object)subEntity);
            int maxIterations = dedupConf.getWf().getMaxIterations();
            log.info("Max iterations {}", (Object)maxIterations);
            String mergeRelPath = DedupUtility.createMergeRelPath(workingPath, actionSetId, subEntity);
            JavaPairRDD vertexes = sc.textFile(graphBasePath + "/" + subEntity).map((Function & Serializable)s -> MapDocumentUtil.getJPathString((String)dedupConf.getWf().getIdPath(), (String)s)).mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)SparkCreateMergeRels.hash(s), s));
            RDD edgeRdd = this.spark.read().load(DedupUtility.createSimRelPath(workingPath, actionSetId, subEntity)).as(Encoders.bean(Relation.class)).javaRDD().map((Function & Serializable)it -> new Edge(SparkCreateMergeRels.hash(it.getSource()), SparkCreateMergeRels.hash(it.getTarget()), (Object)it.getRelClass())).rdd();
            Dataset mergeRels = this.spark.createDataset(GraphProcessor.findCCs((RDD<Tuple2<Object, String>>)vertexes.rdd(), (RDD<Edge<String>>)edgeRdd, maxIterations).toJavaRDD().filter((Function & Serializable)k -> k.getDocIds().size() > 1).flatMap((FlatMapFunction & Serializable)cc -> this.ccToMergeRel((ConnectedComponent)cc, dedupConf)).rdd(), Encoders.bean(Relation.class));
            mergeRels.write().mode(SaveMode.Append).parquet(mergeRelPath);
        }
    }

    public Iterator<Relation> ccToMergeRel(ConnectedComponent cc, DedupConfig dedupConf) {
        return cc.getDocIds().stream().flatMap(id -> {
            ArrayList<Relation> tmp = new ArrayList<Relation>();
            tmp.add(this.rel(cc.getCcId(), (String)id, "merges", dedupConf));
            tmp.add(this.rel((String)id, cc.getCcId(), "isMergedIn", dedupConf));
            return tmp.stream();
        }).iterator();
    }

    private Relation rel(String source, String target, String relClass, DedupConfig dedupConf) {
        String entityType = dedupConf.getWf().getEntityType();
        Relation r = new Relation();
        r.setSource(source);
        r.setTarget(target);
        r.setRelClass(relClass);
        r.setRelType(entityType + entityType.substring(0, 1).toUpperCase() + entityType.substring(1));
        r.setSubRelType("dedup");
        DataInfo info = new DataInfo();
        info.setDeletedbyinference(Boolean.valueOf(false));
        info.setInferred(Boolean.valueOf(true));
        info.setInvisible(Boolean.valueOf(false));
        info.setInferenceprovenance(dedupConf.getWf().getConfigurationId());
        Qualifier provenanceAction = new Qualifier();
        provenanceAction.setClassid(PROVENANCE_ACTION_CLASS);
        provenanceAction.setClassname(PROVENANCE_ACTION_CLASS);
        provenanceAction.setSchemeid(DNET_PROVENANCE_ACTIONS);
        provenanceAction.setSchemename(DNET_PROVENANCE_ACTIONS);
        info.setProvenanceaction(provenanceAction);
        r.setDataInfo(info);
        return r;
    }

    public static long hash(String id) {
        return Hashing.murmur3_128().hashString((CharSequence)id).asLong();
    }
}

