/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.IdGenerator;
import eu.dnetlib.dhp.oa.dedup.SparkCreateSimRels;
import eu.dnetlib.dhp.oa.dedup.graph.ConnectedComponent;
import eu.dnetlib.dhp.oa.dedup.graph.GraphProcessor;
import eu.dnetlib.dhp.oa.dedup.model.Identifier;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.graphx.Edge;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import scala.Tuple2;

public class SparkCreateMergeRels
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateMergeRels.class);

    public SparkCreateMergeRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/createCC_parameters.json")));
        parser.parseArgument(args);
        String isLookUpUrl = parser.get("isLookUpUrl");
        log.info("isLookupUrl {}", (Object)isLookUpUrl);
        SparkConf conf = new SparkConf();
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ModelSupport.getOafModelClasses());
        new SparkCreateMergeRels(parser, SparkCreateMergeRels.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)isLookUpUrl));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws ISLookUpException, DocumentException, IOException, SAXException {
        String graphBasePath = this.parser.get("graphBasePath");
        String workingPath = this.parser.get("workingPath");
        String isLookUpUrl = this.parser.get("isLookUpUrl");
        String actionSetId = this.parser.get("actionSetId");
        int cut = Optional.ofNullable(this.parser.get("cutConnectedComponent")).map(Integer::valueOf).orElse(0);
        log.info("connected component cut: '{}'", (Object)cut);
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("isLookUpUrl:   '{}'", (Object)isLookUpUrl);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)this.spark.sparkContext());
        for (DedupConfig dedupConf : this.getConfigurations(isLookUpService, actionSetId)) {
            String subEntity = dedupConf.getWf().getSubEntityValue();
            Class clazz = (Class)ModelSupport.entityTypes.get(EntityType.valueOf((String)subEntity));
            log.info("Creating mergerels for: '{}'", (Object)subEntity);
            int maxIterations = dedupConf.getWf().getMaxIterations();
            log.info("Max iterations {}", (Object)maxIterations);
            String mergeRelPath = DedupUtility.createMergeRelPath(workingPath, actionSetId, subEntity);
            JavaPairRDD<Object, String> vertexes = this.createVertexes(sc, graphBasePath, subEntity, dedupConf);
            RDD edgeRdd = this.spark.read().load(DedupUtility.createSimRelPath(workingPath, actionSetId, subEntity)).as(Encoders.bean(Relation.class)).javaRDD().map((Function & Serializable)it -> new Edge(SparkCreateMergeRels.hash(it.getSource()), SparkCreateMergeRels.hash(it.getTarget()), (Object)it.getRelClass())).rdd();
            Dataset rawMergeRels = this.spark.createDataset(GraphProcessor.findCCs((RDD<Tuple2<Object, String>>)vertexes.rdd(), (RDD<Edge<String>>)edgeRdd, maxIterations, cut).toJavaRDD().filter((Function & Serializable)k -> k.getIds().size() > 1).flatMap(this::ccToRels).rdd(), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
            Dataset entities = this.spark.read().textFile(DedupUtility.createEntityPath(graphBasePath, subEntity)).map((MapFunction & Serializable)it -> {
                OafEntity entity = (OafEntity)OBJECT_MAPPER.readValue(it, clazz);
                return new Tuple2((Object)entity.getId(), (Object)entity);
            }, Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.kryo((Class)clazz)));
            Dataset mergeRels = rawMergeRels.joinWith(entities, rawMergeRels.col("_2").equalTo((Object)entities.col("_1")), "inner").map((MapFunction & Serializable)value -> new Tuple2(((Tuple2)value._1())._1(), ((Tuple2)value._2())._2()), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.kryo((Class)clazz))).groupByKey(Tuple2::_1, Encoders.STRING()).mapGroups(this::generateID, Encoders.bean(ConnectedComponent.class)).flatMap((FlatMapFunction & Serializable)cc -> this.ccToMergeRel((ConnectedComponent)cc, dedupConf), Encoders.bean(Relation.class));
            mergeRels.write().mode(SaveMode.Overwrite).parquet(mergeRelPath);
        }
    }

    private <T extends OafEntity> ConnectedComponent generateID(String key, Iterator<Tuple2<String, T>> values) {
        List identifiers = Lists.newArrayList(values).stream().map(v -> Identifier.newInstance((OafEntity)v._2())).collect(Collectors.toList());
        String rootID = IdGenerator.generate(identifiers, key);
        if (Objects.equals(rootID, key)) {
            throw new IllegalStateException("generated default ID: " + rootID);
        }
        return new ConnectedComponent(rootID, identifiers.stream().map(i -> i.getEntity().getId()).collect(Collectors.toSet()));
    }

    private JavaPairRDD<Object, String> createVertexes(JavaSparkContext sc, String graphBasePath, String subEntity, DedupConfig dedupConf) {
        return sc.textFile(DedupUtility.createEntityPath(graphBasePath, subEntity)).mapToPair((PairFunction & Serializable)json -> {
            String id = MapDocumentUtil.getJPathString((String)dedupConf.getWf().getIdPath(), (String)json);
            return new Tuple2((Object)SparkCreateMergeRels.hash(id), (Object)id);
        });
    }

    private Iterator<Tuple2<String, String>> ccToRels(ConnectedComponent cc) {
        return cc.getIds().stream().map(id -> new Tuple2((Object)cc.getCcId(), id)).iterator();
    }

    private Iterator<Relation> ccToMergeRel(ConnectedComponent cc, DedupConfig dedupConf) {
        return cc.getIds().stream().flatMap(id -> {
            ArrayList<Relation> tmp = new ArrayList<Relation>();
            tmp.add(this.rel(cc.getCcId(), (String)id, "merges", dedupConf));
            tmp.add(this.rel((String)id, cc.getCcId(), "isMergedIn", dedupConf));
            return tmp.stream();
        }).iterator();
    }

    private Relation rel(String source, String target, String relClass, DedupConfig dedupConf) {
        String entityType = dedupConf.getWf().getEntityType();
        Relation r = new Relation();
        r.setSource(source);
        r.setTarget(target);
        r.setRelClass(relClass);
        r.setRelType(entityType + entityType.substring(0, 1).toUpperCase() + entityType.substring(1));
        r.setSubRelType("dedup");
        DataInfo info = new DataInfo();
        info.setDeletedbyinference(Boolean.valueOf(false));
        info.setInferred(Boolean.valueOf(true));
        info.setInvisible(Boolean.valueOf(false));
        info.setInferenceprovenance(dedupConf.getWf().getConfigurationId());
        Qualifier provenanceAction = new Qualifier();
        provenanceAction.setClassid("sysimport:dedup");
        provenanceAction.setClassname("sysimport:dedup");
        provenanceAction.setSchemeid("dnet:provenanceActions");
        provenanceAction.setSchemename("dnet:provenanceActions");
        info.setProvenanceaction(provenanceAction);
        r.setDataInfo(info);
        return r;
    }

    public static long hash(String id) {
        return Hashing.murmur3_128().hashString((CharSequence)id).asLong();
    }
}

