/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCreateOrgsDedupRecord
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateOrgsDedupRecord.class);

    public SparkCreateOrgsDedupRecord(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateOrgsDedupRecord.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/copyOpenorgs_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkCreateOrgsDedupRecord(parser, SparkCreateOrgsDedupRecord.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws DocumentException, IOException, ISLookUpException {
        String graphBasePath = this.parser.get("graphBasePath");
        String actionSetId = this.parser.get("actionSetId");
        String workingPath = this.parser.get("workingPath");
        int numPartitions = java.util.Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        log.info("numPartitions: '{}'", (Object)numPartitions);
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        log.info("Copying organization dedup records to the working dir");
        String outputPath = DedupUtility.createDedupRecordPath(workingPath, actionSetId, "organization");
        String entityPath = DedupUtility.createEntityPath(graphBasePath, "organization");
        String mergeRelsPath = DedupUtility.createMergeRelPath(workingPath, actionSetId, "organization");
        SparkCreateOrgsDedupRecord.rootOrganization(this.spark, entityPath, mergeRelsPath).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }

    public static Dataset<Organization> rootOrganization(SparkSession spark, String entitiesInputPath, String mergeRelsPath) {
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaPairRDD entities = sc.textFile(entitiesInputPath).map((Function & Serializable)it -> (Organization)OBJECT_MAPPER.readValue(it, Organization.class)).mapToPair((PairFunction & Serializable)o -> new Tuple2((Object)o.getId(), o));
        log.info("Number of organization entities processed: {}", (Object)entities.count());
        JavaPairRDD roots = spark.read().load(mergeRelsPath).as(Encoders.bean(Relation.class)).where("relClass == 'merges'").map((MapFunction & Serializable)r -> new Tuple2((Object)r.getSource(), (Object)"root"), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING())).toJavaRDD().mapToPair((PairFunction & Serializable)t -> t).distinct();
        Dataset rootOrgs = spark.createDataset(entities.leftOuterJoin(roots).filter((Function & Serializable)e -> ((Optional)((Tuple2)e._2())._2()).isPresent()).map((Function & Serializable)e -> (Organization)((Tuple2)e._2())._1()).rdd(), Encoders.bean(Organization.class));
        log.info("Number of Root organization: {}", (Object)entities.count());
        return rootOrgs;
    }
}

