/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.Deduper;
import eu.dnetlib.dhp.oa.dedup.model.Block;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import scala.Tuple2;

public class SparkCreateSimRels
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateSimRels.class);

    public SparkCreateSimRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/createSimRels_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkCreateSimRels(parser, SparkCreateSimRels.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws DocumentException, IOException, ISLookUpException, SAXException {
        String graphBasePath = this.parser.get("graphBasePath");
        String isLookUpUrl = this.parser.get("isLookUpUrl");
        String actionSetId = this.parser.get("actionSetId");
        String workingPath = this.parser.get("workingPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        log.info("numPartitions: '{}'", (Object)numPartitions);
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("isLookUpUrl:   '{}'", (Object)isLookUpUrl);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        for (DedupConfig dedupConf : this.getConfigurations(isLookUpService, actionSetId)) {
            String entity = dedupConf.getWf().getEntityType();
            String subEntity = dedupConf.getWf().getSubEntityValue();
            log.info("Creating simrels for: '{}'", (Object)subEntity);
            String outputPath = DedupUtility.createSimRelPath(workingPath, actionSetId, subEntity);
            SparkCreateSimRels.removeOutputDir(this.spark, outputPath);
            JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)this.spark.sparkContext());
            JavaPairRDD mapDocuments = sc.textFile(DedupUtility.createEntityPath(graphBasePath, subEntity)).repartition(numPartitions).mapToPair((PairFunction & Serializable)s -> {
                MapDocument d = MapDocumentUtil.asMapDocumentWithJPath((DedupConfig)dedupConf, (String)s);
                return new Tuple2((Object)d.getIdentifier(), (Object)d);
            });
            JavaPairRDD blocks = Deduper.createSortedBlocks((JavaPairRDD<String, MapDocument>)mapDocuments, dedupConf).repartition(numPartitions);
            Dataset simRels = this.spark.createDataset(Deduper.computeRelations(sc, (JavaPairRDD<String, Block>)blocks, dedupConf).map((Function & Serializable)t -> DedupUtility.createSimRel((String)t._1(), (String)t._2(), entity)).repartition(numPartitions).rdd(), Encoders.bean(Relation.class));
            SparkCreateSimRels.saveParquet(simRels, outputPath, SaveMode.Overwrite);
        }
    }
}

