/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dedup;

import eu.dnetlib.dedup.DedupUtility;
import eu.dnetlib.dedup.Deduper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public class SparkCreateSimRels {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/dedup_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(SparkCreateSimRels.class.getSimpleName()).master(parser.get("master")).getOrCreate();
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        String inputPath = parser.get("sourcePath");
        String entity = parser.get("entity");
        String targetPath = parser.get("targetPath");
        DedupConfig dedupConf = DedupConfig.load((String)parser.get("dedupConf"));
        long total = sc.textFile(inputPath + "/" + entity).count();
        JavaPairRDD mapDocument = sc.textFile(inputPath + "/" + entity).mapToPair((PairFunction & Serializable)s -> {
            MapDocument d = MapDocumentUtil.asMapDocumentWithJPath((DedupConfig)dedupConf, (String)s);
            return new Tuple2((Object)d.getIdentifier(), (Object)d);
        });
        JavaPairRDD<String, List<MapDocument>> blocks = Deduper.createsortedBlocks(sc, (JavaPairRDD<String, MapDocument>)mapDocument, dedupConf);
        JavaPairRDD<String, String> dedupRels = Deduper.computeRelations2(sc, blocks, dedupConf);
        JavaRDD isSimilarToRDD = dedupRels.map((Function & Serializable)simRel -> {
            Relation r = new Relation();
            r.setSource((String)simRel._1());
            r.setTarget((String)simRel._2());
            r.setRelClass("isSimilarTo");
            return r;
        });
        spark.createDataset(isSimilarToRDD.rdd(), Encoders.bean(Relation.class)).write().mode("overwrite").save(DedupUtility.createSimRelPath(targetPath, entity));
    }
}

