/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;
import eu.dnetlib.dhp.oa.model.Author;
import eu.dnetlib.dhp.oa.model.BestAccessRight;
import eu.dnetlib.dhp.oa.model.Container;
import eu.dnetlib.dhp.oa.model.GeoLocation;
import eu.dnetlib.dhp.oa.model.Indicator;
import eu.dnetlib.dhp.oa.model.Language;
import eu.dnetlib.dhp.oa.model.OpenAccessColor;
import eu.dnetlib.dhp.oa.model.ResultCountry;
import eu.dnetlib.dhp.oa.model.ResultPid;
import eu.dnetlib.dhp.oa.model.Subject;
import java.io.Serializable;
import java.util.List;

public class Result
implements Serializable {
    private List<Author> authors;
    @JsonProperty(value="isGreen")
    @JsonSchema(description="True if the result is green Open Access")
    private Boolean isGreen;
    @JsonSchema(description="The Open Access Color of the publication")
    private OpenAccessColor openAccessColor;
    @JsonProperty(value="isInDiamondJournal")
    @JsonSchema(description="True if the result is published in a Diamond Journal")
    private Boolean isInDiamondJournal;
    @JsonSchema(description="True if the result is outcome of a project")
    private Boolean publiclyFunded;
    @JsonSchema(description="Type of the result: one of 'publication', 'dataset', 'software', 'other' (see also https://api.openaire.eu/vocabularies/dnet:result_typologies)")
    private String type;
    private Language language;
    @JsonSchema(description="The list of countries associated to this result")
    private List<ResultCountry> countries;
    @JsonSchema(description="Keywords associated to the result")
    private List<Subject> subjects;
    @JsonSchema(description="A name or title by which a scientific result is known. May be the title of a publication, of a dataset or the name of a piece of software.")
    private String mainTitle;
    @JsonSchema(description="Explanatory or alternative name by which a scientific result is known.")
    private String subTitle;
    private List<String> descriptions;
    @JsonSchema(description="Main date of the research product: typically the publication or issued date. In case of a research result with different versions with different dates, the date of the result is selected as the most frequent well-formatted date. If not available, then the most recent and complete date among those that are well-formatted. For statistics, the year is extracted and the result is counted only among the result of that year. Example: Pre-print date: 2019-02-03, Article date provided by repository: 2020-02, Article date provided by Crossref: 2020, OpenAIRE will set as date 2019-02-03, because it\u2019s the most recent among the complete and well-formed dates. If then the repository updates the metadata and set a complete date (e.g. 2020-02-12), then this will be the new date for the result because it becomes the most recent most complete date. However, if OpenAIRE then collects the pre-print from another repository with date 2019-02-03, then this will be the \u201cwinning date\u201d because it becomes the most frequent well-formatted date.")
    private String publicationDate;
    @JsonSchema(description="The name of the entity that holds, archives, publishes prints, distributes, releases, issues, or produces the resource.")
    private String publisher;
    @JsonSchema(description="Date when the embargo ends and this result turns Open Access")
    private String embargoEndDate;
    @JsonSchema(description="See definition of Dublin Core field dc:source")
    private List<String> sources;
    private List<String> formats;
    @JsonSchema(description="Contributors for the result")
    private List<String> contributors;
    private List<String> coverages;
    @JsonSchema(description="The openest of the access rights of this result.")
    private BestAccessRight bestAccessRight;
    @JsonSchema(description="Container has information about the conference or journal where the result has been presented or published")
    private Container container;
    @JsonSchema(description="Only for results with type 'software': URL to the software documentation")
    private List<String> documentationUrls;
    @JsonSchema(description="Only for results with type 'software': the URL to the repository with the source code")
    private String codeRepositoryUrl;
    @JsonSchema(description="Only for results with type 'software': the programming language")
    private String programmingLanguage;
    @JsonSchema(description="Only for results with type 'software': Information on the person responsible for providing further information regarding the resource")
    private List<String> contactPeople;
    @JsonSchema(description="Only for results with type 'software': Information on the group responsible for providing further information regarding the resource")
    private List<String> contactGroups;
    @JsonSchema(description="Only for results with type 'other': tool useful for the interpretation and/or re-used of the research product")
    private List<String> tools;
    @JsonSchema(description="Only for results with type 'dataset': the declared size of the dataset")
    private String size;
    @JsonSchema(description="Version of the result")
    private String version;
    @JsonSchema(description="Geolocation information")
    private List<GeoLocation> geoLocations;
    @JsonSchema(description="The OpenAIRE identifiers for this result")
    private String id;
    @JsonSchema(description="Identifiers of the record at the original sources")
    private List<String> originalIds;
    @JsonSchema(description="Persistent identifiers of the result")
    private List<ResultPid> pids;
    @JsonSchema(description="When OpenAIRE collected the record the last time")
    private String dateOfCollection;
    @JsonSchema(description="Timestamp of last update of the record in OpenAIRE")
    private Long lastUpdateTimeStamp;
    @JsonSchema(description="Indicators computed for this result, for example UsageCount ones")
    private Indicator indicators;

    public Boolean getIsGreen() {
        return this.isGreen;
    }

    public void setIsGreen(Boolean green) {
        this.isGreen = green;
    }

    public OpenAccessColor getOpenAccessColor() {
        return this.openAccessColor;
    }

    public void setOpenAccessColor(OpenAccessColor openAccessColor) {
        this.openAccessColor = openAccessColor;
    }

    public Boolean getIsInDiamondJournal() {
        return this.isInDiamondJournal;
    }

    public void setIsInDiamondJournal(Boolean inDiamondJournal) {
        this.isInDiamondJournal = inDiamondJournal;
    }

    public Boolean getPubliclyFunded() {
        return this.publiclyFunded;
    }

    public void setPubliclyFunded(Boolean publiclyFunded) {
        this.publiclyFunded = publiclyFunded;
    }

    public Indicator getIndicators() {
        return this.indicators;
    }

    public void setIndicators(Indicator indicators) {
        this.indicators = indicators;
    }

    public Long getLastUpdateTimeStamp() {
        return this.lastUpdateTimeStamp;
    }

    public void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
        this.lastUpdateTimeStamp = lastUpdateTimeStamp;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getOriginalIds() {
        return this.originalIds;
    }

    public void setOriginalIds(List<String> originalIds) {
        this.originalIds = originalIds;
    }

    public List<ResultPid> getPids() {
        return this.pids;
    }

    public void setPids(List<ResultPid> pids) {
        this.pids = pids;
    }

    public String getDateOfCollection() {
        return this.dateOfCollection;
    }

    public void setDateOfCollection(String dateOfCollection) {
        this.dateOfCollection = dateOfCollection;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public List<ResultCountry> getCountries() {
        return this.countries;
    }

    public void setCountries(List<ResultCountry> countries) {
        this.countries = countries;
    }

    public List<Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<Subject> subjects) {
        this.subjects = subjects;
    }

    public String getMainTitle() {
        return this.mainTitle;
    }

    public void setMainTitle(String mainTitle) {
        this.mainTitle = mainTitle;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<String> descriptions) {
        this.descriptions = descriptions;
    }

    public String getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(String publicationDate) {
        this.publicationDate = publicationDate;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getEmbargoEndDate() {
        return this.embargoEndDate;
    }

    public void setEmbargoEndDate(String embargoEndDate) {
        this.embargoEndDate = embargoEndDate;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public List<String> getFormats() {
        return this.formats;
    }

    public void setFormats(List<String> formats) {
        this.formats = formats;
    }

    public List<String> getContributors() {
        return this.contributors;
    }

    public void setContributors(List<String> contributors) {
        this.contributors = contributors;
    }

    public List<String> getCoverages() {
        return this.coverages;
    }

    public void setCoverages(List<String> coverages) {
        this.coverages = coverages;
    }

    public BestAccessRight getBestAccessRight() {
        return this.bestAccessRight;
    }

    public void setBestAccessRight(BestAccessRight bestAccessRight) {
        this.bestAccessRight = bestAccessRight;
    }

    public List<String> getDocumentationUrls() {
        return this.documentationUrls;
    }

    public void setDocumentationUrls(List<String> documentationUrls) {
        this.documentationUrls = documentationUrls;
    }

    public String getCodeRepositoryUrl() {
        return this.codeRepositoryUrl;
    }

    public void setCodeRepositoryUrl(String codeRepositoryUrl) {
        this.codeRepositoryUrl = codeRepositoryUrl;
    }

    public String getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    public void setProgrammingLanguage(String programmingLanguage) {
        this.programmingLanguage = programmingLanguage;
    }

    public List<String> getContactPeople() {
        return this.contactPeople;
    }

    public void setContactPeople(List<String> contactPeople) {
        this.contactPeople = contactPeople;
    }

    public List<String> getContactGroups() {
        return this.contactGroups;
    }

    public void setContactGroups(List<String> contactGroups) {
        this.contactGroups = contactGroups;
    }

    public List<String> getTools() {
        return this.tools;
    }

    public void setTools(List<String> tools) {
        this.tools = tools;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<GeoLocation> getGeoLocations() {
        return this.geoLocations;
    }

    public void setGeoLocations(List<GeoLocation> geoLocations) {
        this.geoLocations = geoLocations;
    }
}

