/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.model.graph;

import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;
import eu.dnetlib.dhp.oa.model.Container;
import eu.dnetlib.dhp.oa.model.graph.DatasourcePid;
import eu.dnetlib.dhp.oa.model.graph.DatasourceSchemeValue;
import java.io.Serializable;
import java.util.List;

public class Datasource
implements Serializable {
    @JsonSchema(description="The OpenAIRE id of the data source")
    private String id;
    @JsonSchema(description="Original identifiers for the datasource")
    private List<String> originalIds;
    @JsonSchema(description="Persistent identifiers of the datasource")
    private List<DatasourcePid> pids;
    @JsonSchema(description="The type of the datasource. See https://api.openaire.eu/vocabularies/dnet:datasource_typologies")
    private DatasourceSchemeValue type;
    @JsonSchema(description="OpenAIRE guidelines the data source comply with. See also https://guidelines.openaire.eu.")
    private String openaireCompatibility;
    @JsonSchema(description="The official name of the datasource")
    private String officialName;
    @JsonSchema(description="The English name of the datasource")
    private String englishName;
    private String websiteUrl;
    private String logoUrl;
    @JsonSchema(description="The date of last validation against the OpenAIRE guidelines for the datasource records")
    private String dateOfValidation;
    private String description;
    @JsonSchema(description="List of subjects associated to the datasource")
    private List<String> subjects;
    @JsonSchema(description="The languages present in the data source's content, as defined by OpenDOAR.")
    private List<String> languages;
    @JsonSchema(description="Types of content in the data source, as defined by OpenDOAR")
    private List<String> contentTypes;
    @JsonSchema(description="Releasing date of the data source, as defined by re3data.org")
    private String releaseStartDate;
    @JsonSchema(description="Date when the data source went offline or stopped ingesting new research data. As defined by re3data.org")
    private String releaseEndDate;
    @JsonSchema(description="The URL of a mission statement describing the designated community of the data source. As defined by re3data.org")
    private String missionStatementUrl;
    @JsonSchema(description="Type of access to the data source, as defined by re3data.org. Possible values: {open, restricted, closed}")
    private String accessRights;
    @JsonSchema(description="Type of data upload. As defined by re3data.org: one of {open, restricted,closed}")
    private String uploadRights;
    @JsonSchema(description="Access restrinctions to the data source, as defined by re3data.org. One of {feeRequired, registration, other}")
    private String databaseAccessRestriction;
    @JsonSchema(description="Upload restrictions applied by the datasource, as defined by re3data.org. One of {feeRequired, registration, other}")
    private String dataUploadRestriction;
    @JsonSchema(description="As defined by redata.org: 'yes' if the data source supports versioning, 'no' otherwise.")
    private Boolean versioning;
    @JsonSchema(description="The URL of the data source providing information on how to cite its items. As defined by re3data.org.")
    private String citationGuidelineUrl;
    @JsonSchema(description="The persistent identifier system that is used by the data source. As defined by re3data.org")
    private String pidSystems;
    @JsonSchema(description="The certificate, seal or standard the data source complies with. As defined by re3data.org.")
    private String certificates;
    @JsonSchema(description="Policies of the data source, as defined in OpenDOAR.")
    private List<String> policies;
    @JsonSchema(description="Information about the journal, if this data source is of type Journal.")
    private Container journal;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getOriginalIds() {
        return this.originalIds;
    }

    public void setOriginalIds(List<String> originalIds) {
        this.originalIds = originalIds;
    }

    public List<DatasourcePid> getPids() {
        return this.pids;
    }

    public void setPids(List<DatasourcePid> pids) {
        this.pids = pids;
    }

    public DatasourceSchemeValue getType() {
        return this.type;
    }

    public void setType(DatasourceSchemeValue type) {
        this.type = type;
    }

    public String getOpenaireCompatibility() {
        return this.openaireCompatibility;
    }

    public void setOpenaireCompatibility(String openaireCompatibility) {
        this.openaireCompatibility = openaireCompatibility;
    }

    public String getOfficialName() {
        return this.officialName;
    }

    public void setOfficialName(String officialName) {
        this.officialName = officialName;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public void setWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getDateOfValidation() {
        return this.dateOfValidation;
    }

    public void setDateOfValidation(String dateOfValidation) {
        this.dateOfValidation = dateOfValidation;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public List<String> getContentTypes() {
        return this.contentTypes;
    }

    public void setContentTypes(List<String> contentTypes) {
        this.contentTypes = contentTypes;
    }

    public String getReleaseStartDate() {
        return this.releaseStartDate;
    }

    public void setReleaseStartDate(String releaseStartDate) {
        this.releaseStartDate = releaseStartDate;
    }

    public String getReleaseEndDate() {
        return this.releaseEndDate;
    }

    public void setReleaseEndDate(String releaseEndDate) {
        this.releaseEndDate = releaseEndDate;
    }

    public String getMissionStatementUrl() {
        return this.missionStatementUrl;
    }

    public void setMissionStatementUrl(String missionStatementUrl) {
        this.missionStatementUrl = missionStatementUrl;
    }

    public String getAccessRights() {
        return this.accessRights;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = accessRights;
    }

    public String getUploadRights() {
        return this.uploadRights;
    }

    public void setUploadRights(String uploadRights) {
        this.uploadRights = uploadRights;
    }

    public String getDatabaseAccessRestriction() {
        return this.databaseAccessRestriction;
    }

    public void setDatabaseAccessRestriction(String databaseAccessRestriction) {
        this.databaseAccessRestriction = databaseAccessRestriction;
    }

    public String getDataUploadRestriction() {
        return this.dataUploadRestriction;
    }

    public void setDataUploadRestriction(String dataUploadRestriction) {
        this.dataUploadRestriction = dataUploadRestriction;
    }

    public Boolean getVersioning() {
        return this.versioning;
    }

    public void setVersioning(Boolean versioning) {
        this.versioning = versioning;
    }

    public String getCitationGuidelineUrl() {
        return this.citationGuidelineUrl;
    }

    public void setCitationGuidelineUrl(String citationGuidelineUrl) {
        this.citationGuidelineUrl = citationGuidelineUrl;
    }

    public String getPidSystems() {
        return this.pidSystems;
    }

    public void setPidSystems(String pidSystems) {
        this.pidSystems = pidSystems;
    }

    public String getCertificates() {
        return this.certificates;
    }

    public void setCertificates(String certificates) {
        this.certificates = certificates;
    }

    public List<String> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<String> policiesr3) {
        this.policies = policiesr3;
    }

    public Container getJournal() {
        return this.journal;
    }

    public void setJournal(Container journal) {
        this.journal = journal;
    }
}

