/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.orcidtoresultfromsemrel;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.orcidtoresultfromsemrel.SparkOrcidToResultFromSemRelJob;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcidPropagationJobTest {
    private static final Logger log = LoggerFactory.getLogger(OrcidPropagationJobTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(OrcidPropagationJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(OrcidPropagationJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(OrcidPropagationJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void noUpdateTest() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/orcidtoresultfromsemrel/sample/noupdate").getPath();
        String possibleUpdatesPath = this.getClass().getResource("/eu/dnetlib/dhp/orcidtoresultfromsemrel/preparedInfo/mergedOrcidAssoc").getPath();
        SparkOrcidToResultFromSemRelJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", sourcePath, "-hive_metastore_uris", "", "-saveGraph", "true", "-resultTableName", Dataset.class.getCanonicalName(), "-outputPath", workingDir.toString() + "/dataset", "-possibleUpdatesPath", possibleUpdatesPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/dataset").map((Function & Serializable)item -> (Dataset)OBJECT_MAPPER.readValue(item, Dataset.class));
        Assertions.assertEquals((long)10L, (long)tmp.count());
        org.apache.spark.sql.Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(Dataset.class));
        verificationDataset.createOrReplaceTempView("dataset");
        String query = "select id from dataset lateral view explode(author) a as MyT lateral view explode(MyT.pid) p as MyP where MyP.datainfo.inferenceprovenance = 'propagation'";
        Assertions.assertEquals((long)0L, (long)spark.sql(query).count());
    }

    @Test
    void oneUpdateTest() throws Exception {
        SparkOrcidToResultFromSemRelJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", this.getClass().getResource("/eu/dnetlib/dhp/orcidtoresultfromsemrel/sample/oneupdate").getPath(), "-hive_metastore_uris", "", "-saveGraph", "true", "-resultTableName", "eu.dnetlib.dhp.schema.oaf.Dataset", "-outputPath", workingDir.toString() + "/dataset", "-possibleUpdatesPath", this.getClass().getResource("/eu/dnetlib/dhp/orcidtoresultfromsemrel/preparedInfo/mergedOrcidAssoc").getPath()});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/dataset").map((Function & Serializable)item -> (Dataset)OBJECT_MAPPER.readValue(item, Dataset.class));
        Assertions.assertEquals((long)10L, (long)tmp.count());
        org.apache.spark.sql.Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(Dataset.class));
        verificationDataset.createOrReplaceTempView("dataset");
        String query = "select id, MyT.name name, MyT.surname surname, MyP.value pid, MyP.qualifier.classid pidType from dataset lateral view explode(author) a as MyT lateral view explode(MyT.pid) p as MyP where MyP.datainfo.inferenceprovenance = 'propagation'";
        org.apache.spark.sql.Dataset propagatedAuthors = spark.sql(query);
        Assertions.assertEquals((long)1L, (long)propagatedAuthors.count());
        Assertions.assertEquals((long)1L, (long)propagatedAuthors.filter("id = '50|dedup_wf_001::95b033c0c3961f6a1cdcd41a99a9632e' and name = 'Vajinder' and surname = 'Kumar' and pidType = 'orcid_pending'").count());
        Assertions.assertEquals((long)1L, (long)propagatedAuthors.filter("pid = '0000-0002-8825-3517'").count());
    }

    @Test
    void twoUpdatesTest() throws Exception {
        SparkOrcidToResultFromSemRelJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", this.getClass().getResource("/eu/dnetlib/dhp/orcidtoresultfromsemrel/sample/twoupdates").getPath(), "-hive_metastore_uris", "", "-saveGraph", "true", "-resultTableName", "eu.dnetlib.dhp.schema.oaf.Dataset", "-outputPath", workingDir.toString() + "/dataset", "-possibleUpdatesPath", this.getClass().getResource("/eu/dnetlib/dhp/orcidtoresultfromsemrel/preparedInfo/mergedOrcidAssoc").getPath()});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/dataset").map((Function & Serializable)item -> (Dataset)OBJECT_MAPPER.readValue(item, Dataset.class));
        Assertions.assertEquals((long)10L, (long)tmp.count());
        org.apache.spark.sql.Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(Dataset.class));
        verificationDataset.createOrReplaceTempView("dataset");
        String query = "select id, MyT.name name, MyT.surname surname, MyP.value pid, MyP.qualifier.classid pidType from dataset lateral view explode(author) a as MyT lateral view explode(MyT.pid) p as MyP where MyP.datainfo.inferenceprovenance = 'propagation'";
        org.apache.spark.sql.Dataset propagatedAuthors = spark.sql(query);
        Assertions.assertEquals((long)2L, (long)propagatedAuthors.count());
        Assertions.assertEquals((long)1L, (long)propagatedAuthors.filter("name = 'Marc' and surname = 'Schmidtmann'").count());
        Assertions.assertEquals((long)1L, (long)propagatedAuthors.filter("name = 'Ruediger' and surname = 'Beckhaus'").count());
        query = "select id, MyT.name name, MyT.surname surname, MyP.value pid ,MyP.qualifier.classid pidType from dataset lateral view explode(author) a as MyT lateral view explode(MyT.pid) p as MyP ";
        org.apache.spark.sql.Dataset authorsExplodedPids = spark.sql(query);
        Assertions.assertEquals((long)2L, (long)authorsExplodedPids.filter("name = 'Marc' and surname = 'Schmidtmann'").count());
        Assertions.assertEquals((long)1L, (long)authorsExplodedPids.filter("name = 'Marc' and surname = 'Schmidtmann' and pidType = 'MAG Identifier'").count());
    }
}

