/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttoorganizationfrominstrepo;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.resulttoorganizationfrominstrepo.SparkResultToOrganizationFromIstRepoJob;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultToOrganizationJobTest {
    private static final Logger log = LoggerFactory.getLogger(ResultToOrganizationJobTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(SparkResultToOrganizationFromIstRepoJob.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(SparkResultToOrganizationFromIstRepoJob.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(SparkResultToOrganizationFromIstRepoJob.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void NoUpdateTest() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/sample/noupdate_updatenomix").getPath();
        String datasourceOrganizationPath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/noupdate/preparedInfo/datasourceOrganization").getPath();
        String alreadyLinkedPath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/noupdate/preparedInfo/alreadyLinked").getPath();
        SparkResultToOrganizationFromIstRepoJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", sourcePath, "-hive_metastore_uris", "", "-resultTableName", "eu.dnetlib.dhp.schema.oaf.Software", "-saveGraph", "true", "-outputPath", workingDir.toString() + "/relation", "-datasourceOrganizationPath", datasourceOrganizationPath, "-alreadyLinkedPath", alreadyLinkedPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)0L, (long)tmp.count());
        FileUtils.deleteDirectory((File)workingDir.toFile());
    }

    @Test
    void UpdateNoMixTest() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/sample/noupdate_updatenomix").getPath();
        String datasourceOrganizationPath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/updatenomix/preparedInfo/datasourceOrganization").getPath();
        String alreadyLinkedPath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/updatenomix/preparedInfo/alreadyLinked").getPath();
        SparkResultToOrganizationFromIstRepoJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", sourcePath, "-hive_metastore_uris", "", "-resultTableName", "eu.dnetlib.dhp.schema.oaf.Software", "-saveGraph", "true", "-outputPath", workingDir.toString() + "/relation", "-datasourceOrganizationPath", datasourceOrganizationPath, "-alreadyLinkedPath", alreadyLinkedPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)20L, (long)tmp.count());
        Dataset verificationDs = spark.createDataset(tmp.rdd(), Encoders.bean(Relation.class));
        Assertions.assertEquals((long)8L, (long)verificationDs.filter("target = '20|dedup_wf_001::5168917a6aeeea55269daeac1af2ecd2'").count());
        Assertions.assertEquals((long)1L, (long)verificationDs.filter("target = '20|opendoar____::124266ebc4ece2934eb80edfda3f2091'").count());
        Assertions.assertEquals((long)1L, (long)verificationDs.filter("target = '20|opendoar____::4429502fa1936b0941f4647b69b844c8'").count());
        Assertions.assertEquals((long)2L, (long)verificationDs.filter("source = '50|dedup_wf_001::b67bc915603fc01e445f2b5888ba7218' and (target = '20|opendoar____::124266ebc4ece2934eb80edfda3f2091' or target = '20|dedup_wf_001::5168917a6aeeea55269daeac1af2ecd2')").count());
        FileUtils.deleteDirectory((File)workingDir.toFile());
    }

    @Test
    void UpdateMixTest() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/sample/updatemix").getPath();
        String datasourceOrganizationPath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/updatemix/preparedInfo/datasourceOrganization").getPath();
        String alreadyLinkedPath = this.getClass().getResource("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/updatemix/preparedInfo/alreadyLinked").getPath();
        SparkResultToOrganizationFromIstRepoJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", sourcePath, "-hive_metastore_uris", "", "-resultTableName", "eu.dnetlib.dhp.schema.oaf.Software", "-saveGraph", "true", "-outputPath", workingDir.toString() + "/relation", "-datasourceOrganizationPath", datasourceOrganizationPath, "-alreadyLinkedPath", alreadyLinkedPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Dataset verificationDs = spark.createDataset(tmp.rdd(), Encoders.bean(Relation.class));
        Assertions.assertEquals((long)8L, (long)verificationDs.count());
        Assertions.assertEquals((long)2L, (long)verificationDs.filter("source = '50|od_______109::f375befa62a741e9250e55bcfa88f9a6'").count());
        Assertions.assertEquals((long)1L, (long)verificationDs.filter("source = '50|dedup_wf_001::b67bc915603fc01e445f2b5888ba7218'").count());
        Assertions.assertEquals((long)1L, (long)verificationDs.filter("source = '50|dedup_wf_001::40ea2f24181f6ae77b866ebcbffba523'").count());
        Assertions.assertEquals((long)1L, (long)verificationDs.filter("source = '20|wt__________::a72760363ca885e6bef165804770e00c'").count());
        Assertions.assertEquals((long)4L, (long)verificationDs.filter("relclass = 'hasAuthorInstitution' and substring(source, 1,2) = '50'").count());
        Assertions.assertEquals((long)4L, (long)verificationDs.filter("relclass = 'isAuthorInstitutionOf' and substring(source, 1,2) = '20'").count());
        Assertions.assertEquals((long)4L, (long)verificationDs.filter("relclass = 'hasAuthorInstitution' and substring(source, 1,2) = '50' and substring(target, 1, 2) = '20'").count());
        Assertions.assertEquals((long)4L, (long)verificationDs.filter("relclass = 'isAuthorInstitutionOf' and substring(source, 1,2) = '20' and substring(target, 1, 2) = '50'").count());
        FileUtils.deleteDirectory((File)workingDir.toFile());
    }
}

