package eu.dnetlib.dhp.schema.solr;

import java.io.Serializable;

/**
 * Represents a declared affiliation in the context of a Person record.
 * This class encapsulates the ROR ID and OpenOrg ID associated with an affiliation.
 */
public class DeclaredAffiliation implements Serializable {

    private static final long serialVersionUID = -4551015348787319383L;

    private String rorId;

    private String openOrgId;

    public static DeclaredAffiliation newInstance(String rorId, String openOrgId) {
        DeclaredAffiliation affiliation = new DeclaredAffiliation();
        affiliation.setRorId(rorId);
        affiliation.setOpenOrgId(openOrgId);
        return affiliation;
    }

    public String getRorId() {
        return rorId;
    }

    public void setRorId(String rorId) {
        this.rorId = rorId;
    }

    public String getOpenOrgId() {
        return openOrgId;
    }

    public void setOpenOrgId(String openOrgId) {
        this.openOrgId = openOrgId;
    }
}
