/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager.utils;

import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.ListResponse;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.Note;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.Paragraph;
import eu.dnetlib.data.mdstore.manager.utils.zeppelin.StringResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ZeppelinClient {
    @Value(value="${dhp.mdstore-manager.hadoop.zeppelin.login}")
    private String zeppelinLogin;
    @Value(value="${dhp.mdstore-manager.hadoop.zeppelin.password}")
    private String zeppelinPassword;
    @Value(value="${dhp.mdstore-manager.hadoop.zeppelin.base-url}")
    private String zeppelinBaseUrl;
    @Value(value="${dhp.mdstore-manager.hadoop.zeppelin.name-prefix}")
    private String zeppelinNamePrefix;
    private static final Log log = LogFactory.getLog(ZeppelinClient.class);

    public String zeppelinNote(String note, String mdId, String currentVersion, String currentVersionPath) throws MDStoreManagerException {
        String jsessionid = this.obtainJsessionID();
        String newName = this.zeppelinNamePrefix + "/notes/" + note + "/" + currentVersion;
        Optional<String> oldNoteId = this.listNotes(jsessionid).stream().filter(Objects::nonNull).filter(map -> newName.equals(map.get("name"))).map(map -> (String)map.get("id")).findFirst();
        if (oldNoteId.isPresent()) {
            log.info((Object)("Returning existing note: " + oldNoteId.get()));
            return this.zeppelinBaseUrl + "/#/notebook/" + oldNoteId.get();
        }
        String templateNoteId = this.findTemplateNoteId(note, jsessionid);
        String newId = this.cloneNote(templateNoteId, newName, jsessionid);
        log.info((Object)("New note created, id: " + newId + ", name: " + newName));
        this.addParagraph(newId, this.confParagraph(mdId, currentVersion, currentVersionPath), jsessionid);
        this.reassignRights(newId, jsessionid);
        return this.zeppelinBaseUrl + "/#/notebook/" + newId;
    }

    public void cleanExpiredNotes() {
        try {
            String jsessionid = this.obtainJsessionID();
            for (Map n : this.listNotes(jsessionid)) {
                String id = (String)n.get("id");
                if (!((String)n.get("name")).startsWith(this.zeppelinNamePrefix + "/notes/") || !this.isExpired(id, jsessionid)) continue;
                this.deleteNote(id, jsessionid);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error cleaning expired notes", (Throwable)e);
        }
    }

    private String obtainJsessionID() throws MDStoreManagerException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"userName", (Object)this.zeppelinLogin);
        map.add((Object)"password", (Object)this.zeppelinPassword);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        String url = this.zeppelinBaseUrl + "/api/login";
        ResponseEntity res = new RestTemplate().postForEntity(url, (Object)request, Object.class, new Object[0]);
        if (res.getStatusCode() != HttpStatus.OK) {
            log.error((Object)("Zeppelin API: login failed with HTTP error: " + res));
            throw new MDStoreManagerException("Zeppelin API: login failed with HTTP error: " + res);
        }
        if (!res.getHeaders().containsKey((Object)"Set-Cookie")) {
            log.error((Object)"Zeppelin API: login failed (missing SET_COOKIE header)");
            throw new MDStoreManagerException("Zeppelin API: login failed (missing SET_COOKIE header)");
        }
        return res.getHeaders().get((Object)"Set-Cookie").stream().map(s -> s.split(";")).flatMap(Arrays::stream).map(String::trim).filter(s -> s.startsWith("JSESSIONID=")).map(s -> StringUtils.removeStart((String)s, (String)"JSESSIONID=")).filter(s -> !s.equalsIgnoreCase("deleteMe")).distinct().filter(arg_0 -> this.testConnection(arg_0)).findFirst().orElseThrow(() -> new MDStoreManagerException("Zeppelin API: login failed (invalid jsessionid)"));
    }

    private boolean testConnection(String jsessionid) {
        String url = this.zeppelinBaseUrl + "/api/notebook;JSESSIONID=" + jsessionid;
        log.info((Object)("Performing GET: " + url));
        ResponseEntity res = new RestTemplate().getForEntity(url, ListResponse.class, new Object[0]);
        if (res.getStatusCode() != HttpStatus.OK) {
            return false;
        }
        if (res.getBody() == null) {
            return false;
        }
        if (!((ListResponse)res.getBody()).getStatus().equals("OK")) {
            return false;
        }
        log.info((Object)("Connected to zeppelin: " + res.getBody()));
        log.info((Object)("Found JSESSIONID: " + jsessionid));
        return true;
    }

    private List<Map<String, String>> listNotes(String jsessionid) throws MDStoreManagerException {
        String url = this.zeppelinBaseUrl + "/api/notebook;JSESSIONID=" + jsessionid;
        log.info((Object)("Performing GET: " + url));
        ResponseEntity res = new RestTemplate().getForEntity(url, ListResponse.class, new Object[0]);
        if (res.getStatusCode() != HttpStatus.OK) {
            log.error((Object)("Zeppelin API failed with HTTP error: " + res));
            throw new MDStoreManagerException("Zeppelin API failed with HTTP error: " + res);
        }
        if (res.getBody() == null) {
            log.error((Object)"Zeppelin API returned a null response");
            throw new MDStoreManagerException("Zeppelin API returned a null response");
        }
        if (!((ListResponse)res.getBody()).getStatus().equals("OK")) {
            log.error((Object)("Registration of zeppelin note failed: " + res.getBody()));
            throw new MDStoreManagerException("Registration of zeppelin note failed: " + res.getBody());
        }
        return ((ListResponse)res.getBody()).getBody();
    }

    private String findTemplateNoteId(String noteTemplate, String jsessionid) throws MDStoreManagerException {
        String templateName = this.zeppelinNamePrefix + "/templates/" + noteTemplate;
        return this.listNotes(jsessionid).stream().filter(map -> ((String)map.get("name")).equals(templateName)).map(map -> (String)map.get("id")).findFirst().orElseThrow(() -> new MDStoreManagerException("Template Note not found: " + templateName));
    }

    private String cloneNote(String noteId, String newName, String jsessionid) throws MDStoreManagerException {
        String url = this.zeppelinBaseUrl + "/api/notebook/" + noteId + ";JSESSIONID=" + jsessionid;
        log.debug((Object)("Performing POST: " + url));
        ResponseEntity res = new RestTemplate().postForEntity(url, (Object)new Note(newName), StringResponse.class, new Object[0]);
        if (res.getStatusCode() != HttpStatus.OK) {
            log.error((Object)("Zeppelin API failed with HTTP error: " + res));
            throw new MDStoreManagerException("Zeppelin API failed with HTTP error: " + res);
        }
        if (res.getBody() == null) {
            log.error((Object)"Zeppelin API returned a null response");
            throw new MDStoreManagerException("Zeppelin API returned a null response");
        }
        if (!((StringResponse)res.getBody()).getStatus().equals("OK")) {
            log.error((Object)("Registration of zeppelin note failed: " + res.getBody()));
            throw new MDStoreManagerException("Registration of zeppelin note failed: " + res.getBody());
        }
        return ((StringResponse)res.getBody()).getBody();
    }

    private Paragraph confParagraph(String mdId, String currentVersion, String currentVersionPath) throws MDStoreManagerException {
        try {
            String code = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/zeppelin/conf.tmpl.py")).replaceAll("__MDSTORE_ID__", mdId).replaceAll("__VERSION__", currentVersion).replaceAll("__PATH__", currentVersionPath);
            return new Paragraph("Configuration", code, 0);
        }
        catch (IOException e) {
            log.error((Object)"Error preparing configuration paragraph", (Throwable)e);
            throw new MDStoreManagerException("Error preparing configuration paragraph", (Throwable)e);
        }
    }

    private String addParagraph(String noteId, Paragraph paragraph, String jsessionid) throws MDStoreManagerException {
        String url = this.zeppelinBaseUrl + "/api/notebook/" + noteId + "/paragraph;JSESSIONID=" + jsessionid;
        log.debug((Object)("Performing POST: " + url));
        ResponseEntity res = new RestTemplate().postForEntity(url, (Object)paragraph, StringResponse.class, new Object[0]);
        if (res.getStatusCode() != HttpStatus.OK) {
            log.error((Object)("Zeppelin API failed with HTTP error: " + res));
            throw new MDStoreManagerException("Zeppelin API failed with HTTP error: " + res);
        }
        if (res.getBody() == null) {
            log.error((Object)"Zeppelin API returned a null response");
            throw new MDStoreManagerException("Zeppelin API returned a null response");
        }
        if (!((StringResponse)res.getBody()).getStatus().equals("OK")) {
            log.error((Object)("Registration of zeppelin note failed: " + res.getBody()));
            throw new MDStoreManagerException("Registration of zeppelin note failed: " + res.getBody());
        }
        return ((StringResponse)res.getBody()).getBody();
    }

    private void reassignRights(String noteId, String jsessionid) {
        String url = this.zeppelinBaseUrl + "/api/notebook/" + noteId + "/permissions;JSESSIONID=" + jsessionid;
        log.info((Object)("Performing PUT: " + url));
        LinkedHashMap<String, List<String>> rights = new LinkedHashMap<String, List<String>>();
        rights.put("owners", Arrays.asList(this.zeppelinLogin));
        rights.put("readers", new ArrayList());
        rights.put("runners", new ArrayList());
        rights.put("writers", new ArrayList());
        new RestTemplate().put(url, rights, new Object[0]);
    }

    private void deleteNote(String id, String jsessionid) {
        String url = this.zeppelinBaseUrl + "/api/notebook/" + id + ";JSESSIONID=" + jsessionid;
        log.debug((Object)("Performing DELETE: " + url));
        new RestTemplate().delete(url, new Object[0]);
    }

    private boolean isExpired(String id, String jsessionid) {
        return false;
    }
}

