/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager.utils;

import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;
import eu.dnetlib.data.mdstore.manager.repository.MDStoreCurrentVersionRepository;
import eu.dnetlib.data.mdstore.manager.repository.MDStoreRepository;
import eu.dnetlib.data.mdstore.manager.repository.MDStoreVersionRepository;
import eu.dnetlib.data.mdstore.manager.repository.MDStoreWithInfoRepository;
import eu.dnetlib.dhp.schema.mdstore.MDStore;
import eu.dnetlib.dhp.schema.mdstore.MDStoreCurrentVersion;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DatabaseUtils {
    @Autowired
    private MDStoreRepository mdstoreRepository;
    @Autowired
    private MDStoreVersionRepository mdstoreVersionRepository;
    @Autowired
    private MDStoreCurrentVersionRepository mdstoreCurrentVersionRepository;
    @Autowired
    private MDStoreWithInfoRepository mdstoreWithInfoRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${dhp.mdstore-manager.hdfs.base-path}")
    private String hdfsBasePath;
    private static final Logger log = LoggerFactory.getLogger(DatabaseUtils.class);

    public Iterable<MDStoreWithInfo> listMdStores() {
        return this.mdstoreWithInfoRepository.findAll();
    }

    public List<String> listMdStoreIDs() {
        return this.mdstoreRepository.findAll().stream().map(MDStore::getId).collect(Collectors.toList());
    }

    public long countMdStores() {
        return this.mdstoreRepository.count();
    }

    public Iterable<MDStoreVersion> listVersions(String mdId) {
        return this.mdstoreVersionRepository.findByMdstore(mdId);
    }

    public List<String> listExpiredVersions() {
        return this.jdbcTemplate.queryForList("select v.id from mdstore_versions v left outer join mdstore_current_versions cv on (v.id = cv.current_version) where v.writing = false and v.readcount = 0 and cv.mdstore is null;", String.class);
    }

    public MDStoreWithInfo findMdStore(String mdId) throws MDStoreManagerException {
        return (MDStoreWithInfo)this.mdstoreWithInfoRepository.findById((Object)mdId).orElseThrow(() -> new MDStoreManagerException("Missing mdstore: " + mdId));
    }

    public MDStoreVersion findVersion(String versionId) throws MDStoreManagerException {
        return (MDStoreVersion)this.mdstoreVersionRepository.findById((Object)versionId).orElseThrow(() -> new MDStoreManagerException("Missing mdstore version: " + versionId));
    }

    @Transactional
    public String createMDStore(String format, String layout, String interpretation, String dsName, String dsId, String apiId) {
        MDStore md = MDStore.newInstance((String)format, (String)layout, (String)interpretation, (String)dsName, (String)dsId, (String)apiId, (String)this.hdfsBasePath);
        this.mdstoreRepository.save((Object)md);
        MDStoreVersion v = MDStoreVersion.newInstance((String)md.getId(), (boolean)false, (String)this.hdfsBasePath);
        v.setLastUpdate(new Date());
        this.mdstoreVersionRepository.save((Object)v);
        this.mdstoreCurrentVersionRepository.save((Object)MDStoreCurrentVersion.newInstance((MDStoreVersion)v));
        return md.getId();
    }

    @Transactional
    public String deleteMdStore(String mdId) throws MDStoreManagerException {
        Optional md = this.mdstoreRepository.findById((Object)mdId);
        if (!md.isPresent()) {
            log.error("MDStore not found: " + mdId);
            throw new MDStoreManagerException("MDStore not found: " + mdId);
        }
        if (this.mdstoreVersionRepository.countByMdstoreAndReadCountGreaterThan(mdId, 0) > 0L) {
            log.error("Read transactions found on mdstore: " + mdId);
            throw new MDStoreManagerException("Read transactions found on mdstore: " + mdId);
        }
        if (this.mdstoreVersionRepository.countByMdstoreAndWriting(mdId, true) > 0L) {
            log.error("Write transactions found on mdstore: " + mdId);
            throw new MDStoreManagerException("Write transactions found on mdstore: " + mdId);
        }
        this.mdstoreCurrentVersionRepository.deleteById((Object)mdId);
        this.mdstoreVersionRepository.deleteByMdstore(mdId);
        this.mdstoreRepository.deleteById((Object)mdId);
        return ((MDStore)md.get()).getHdfsPath();
    }

    @Transactional
    public MDStoreVersion startReading(String mdId) throws MDStoreManagerException {
        MDStoreCurrentVersion cv = (MDStoreCurrentVersion)this.mdstoreCurrentVersionRepository.findById((Object)mdId).orElseThrow(() -> new MDStoreManagerException("Missing mdstore: " + mdId));
        MDStoreVersion v = (MDStoreVersion)this.mdstoreVersionRepository.findById((Object)cv.getCurrentVersion()).orElseThrow(() -> new MDStoreManagerException("Missing version: " + cv.getCurrentVersion()));
        v.setReadCount(v.getReadCount() + 1);
        this.mdstoreVersionRepository.save((Object)v);
        return v;
    }

    @Transactional
    public MDStoreVersion endReading(String versionId) throws MDStoreManagerException {
        MDStoreVersion v = (MDStoreVersion)this.mdstoreVersionRepository.findById((Object)versionId).orElseThrow(() -> new MDStoreManagerException("Version not found"));
        v.setReadCount(Math.max(0, v.getReadCount() - 1));
        return v;
    }

    @Transactional
    public MDStoreVersion resetReading(String versionId) throws MDStoreManagerException {
        MDStoreVersion v = (MDStoreVersion)this.mdstoreVersionRepository.findById((Object)versionId).orElseThrow(() -> new MDStoreManagerException("Version not found"));
        v.setReadCount(0);
        return v;
    }

    @Transactional
    public MDStoreVersion prepareMdStoreVersion(String mdId) {
        MDStoreVersion v = MDStoreVersion.newInstance((String)mdId, (boolean)true, (String)this.hdfsBasePath);
        this.mdstoreVersionRepository.save((Object)v);
        return v;
    }

    @Transactional
    public MDStoreVersion commitMdStoreVersion(String versionId, long size) throws MDStoreManagerException {
        MDStoreVersion v = (MDStoreVersion)this.mdstoreVersionRepository.findById((Object)versionId).orElseThrow(() -> new MDStoreManagerException("Invalid version: " + versionId));
        this.mdstoreCurrentVersionRepository.save((Object)MDStoreCurrentVersion.newInstance((MDStoreVersion)v));
        v.setWriting(false);
        v.setSize(size);
        v.setLastUpdate(new Date());
        this.mdstoreVersionRepository.save((Object)v);
        return v;
    }

    @Transactional
    public String deleteMdStoreVersion(String versionId, boolean force) throws MDStoreManagerException {
        MDStoreVersion v = (MDStoreVersion)this.mdstoreVersionRepository.findById((Object)versionId).orElseThrow(() -> new MDStoreManagerException("Version not found"));
        if (this.mdstoreCurrentVersionRepository.countByCurrentVersion(versionId) > 0L) {
            throw new MDStoreManagerException("I cannot delete this version because it is the current version");
        }
        if (!force) {
            if (v.isWriting()) {
                throw new MDStoreManagerException("I cannot delete this version because it is in write mode");
            }
            if (v.getReadCount() > 0) {
                throw new MDStoreManagerException("I cannot delete this version because it is in read mode");
            }
        }
        this.mdstoreVersionRepository.delete((Object)v);
        return v.getHdfsPath();
    }

    public Set<String> listValidHdfsPaths() {
        return new HashSet<String>(this.jdbcTemplate.queryForList(" select hdfs_path from mdstores union all select hdfs_path from mdstore_versions", String.class));
    }

    public String getHdfsBasePath() {
        return this.hdfsBasePath;
    }

    public void setHdfsBasePath(String hdfsBasePath) {
        this.hdfsBasePath = hdfsBasePath;
    }
}

