/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager.controller;

import com.google.common.collect.Sets;
import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.data.mdstore.manager.controller.StatusResponse;
import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;
import eu.dnetlib.data.mdstore.manager.utils.DatabaseUtils;
import eu.dnetlib.data.mdstore.manager.utils.HdfsClient;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdstores"})
@Tag(name="Metadata Stores")
public class MDStoreController
extends AbstractDnetController {
    @Autowired
    private DatabaseUtils databaseUtils;
    @Autowired
    private HdfsClient hdfsClient;
    private static final Logger log = LoggerFactory.getLogger(DatabaseUtils.class);

    @Operation(summary="Return all the mdstores")
    @GetMapping(value={"/"})
    public Iterable<MDStoreWithInfo> find() {
        return this.databaseUtils.listMdStores();
    }

    @Operation(summary="Return all the mdstore identifiers")
    @GetMapping(value={"/ids"})
    public List<String> findIdentifiers() {
        return this.databaseUtils.listMdStoreIDs();
    }

    @Operation(summary="Return a mdstores by id")
    @GetMapping(value={"/mdstore/{mdId}"})
    public MDStoreWithInfo getMdStore(@Parameter(name="the mdstore identifier") @PathVariable String mdId) throws MDStoreManagerException {
        return this.databaseUtils.findMdStore(mdId);
    }

    @Operation(summary="Increase the read count of the current mdstore")
    @GetMapping(value={"/mdstore/{mdId}/startReading"})
    public MDStoreVersion startReading(@Parameter(name="the mdstore identifier") @PathVariable String mdId) throws MDStoreManagerException {
        return this.databaseUtils.startReading(mdId);
    }

    @Operation(summary="Create a new mdstore")
    @GetMapping(value={"/new/{format}/{layout}/{interpretation}"})
    public MDStoreWithInfo createMDStore(@Parameter(name="mdstore format") @PathVariable String format, @Parameter(name="mdstore layout") @PathVariable String layout, @Parameter(name="mdstore interpretation") @PathVariable String interpretation, @Parameter(name="datasource name") @RequestParam(required=true) String dsName, @Parameter(name="datasource id") @RequestParam(required=true) String dsId, @Parameter(name="api id") @RequestParam(required=true) String apiId) throws MDStoreManagerException {
        String id = this.databaseUtils.createMDStore(format, layout, interpretation, dsName, dsId, apiId);
        return this.databaseUtils.findMdStore(id);
    }

    @Operation(summary="Delete a mdstore by id")
    @DeleteMapping(value={"/mdstore/{mdId}"})
    public StatusResponse delete(@Parameter(name="the id of the mdstore that will be deleted") @PathVariable String mdId) throws MDStoreManagerException {
        String hdfsPath = this.databaseUtils.deleteMdStore(mdId);
        this.hdfsClient.deletePath(hdfsPath);
        return StatusResponse.DELETED;
    }

    @Operation(summary="Return all the versions of a mdstore")
    @GetMapping(value={"/mdstore/{mdId}/versions"})
    public Iterable<MDStoreVersion> listVersions(@PathVariable String mdId) throws MDStoreManagerException {
        return this.databaseUtils.listVersions(mdId);
    }

    @Operation(summary="Create a new preliminary version of a mdstore")
    @GetMapping(value={"/mdstore/{mdId}/newVersion"})
    public MDStoreVersion prepareNewVersion(@Parameter(name="the id of the mdstore for which will be created a new version") @PathVariable String mdId) {
        return this.databaseUtils.prepareMdStoreVersion(mdId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Promote a preliminary version to current")
    @GetMapping(value={"/version/{versionId}/commit/{size}"})
    public MDStoreVersion commitVersion(@Parameter(name="the id of the version that will be promoted to the current version") @PathVariable String versionId, @Parameter(name="the size of the new current mdstore") @PathVariable long size) throws MDStoreManagerException {
        try {
            MDStoreVersion mDStoreVersion = this.databaseUtils.commitMdStoreVersion(versionId, size);
            return mDStoreVersion;
        }
        finally {
            this.deleteExpiredVersions();
        }
    }

    @Operation(summary="Abort a preliminary version")
    @GetMapping(value={"/version/{versionId}/abort"})
    public StatusResponse commitVersion(@Parameter(name="the id of the version to abort") @PathVariable String versionId) throws MDStoreManagerException {
        String hdfsPath = this.databaseUtils.deleteMdStoreVersion(versionId, true);
        this.hdfsClient.deletePath(hdfsPath);
        return StatusResponse.ABORTED;
    }

    @Operation(summary="Return an existing mdstore version")
    @GetMapping(value={"/version/{versionId}"})
    public MDStoreVersion getVersion(@Parameter(name="the id of the version that has to be deleted") @PathVariable String versionId) throws MDStoreManagerException {
        return this.databaseUtils.findVersion(versionId);
    }

    @Operation(summary="Delete a mdstore version")
    @DeleteMapping(value={"/version/{versionId}"})
    public StatusResponse deleteVersion(@Parameter(name="the id of the version that has to be deleted") @PathVariable String versionId, @Parameter(name="if true, the controls on writing and readcount values will be skipped") @RequestParam(required=false, defaultValue="false") boolean force) throws MDStoreManagerException {
        String hdfsPath = this.databaseUtils.deleteMdStoreVersion(versionId, force);
        this.hdfsClient.deletePath(hdfsPath);
        return StatusResponse.DELETED;
    }

    @Operation(summary="Decrease the read count of a mdstore version")
    @GetMapping(value={"/version/{versionId}/endReading"})
    public MDStoreVersion endReading(@Parameter(name="the id of the version that has been completely read") @PathVariable String versionId) throws MDStoreManagerException {
        return this.databaseUtils.endReading(versionId);
    }

    @Operation(summary="Reset the read count of a mdstore version")
    @GetMapping(value={"/version/{versionId}/resetReading"})
    public MDStoreVersion resetReading(@Parameter(name="the id of the version") @PathVariable String versionId) throws MDStoreManagerException {
        return this.databaseUtils.resetReading(versionId);
    }

    @Operation(summary="Delete expired versions")
    @DeleteMapping(value={"/versions/expired"})
    public StatusResponse deleteExpiredVersions() {
        new Thread(() -> this.performDeleteOfExpiredVersions()).start();
        return StatusResponse.DELETING;
    }

    private synchronized void performDeleteOfExpiredVersions() {
        log.info("Deleting expired version...");
        for (String versionId : this.databaseUtils.listExpiredVersions()) {
            try {
                String hdfsPath = this.databaseUtils.deleteMdStoreVersion(versionId, true);
                this.hdfsClient.deletePath(hdfsPath);
            }
            catch (MDStoreManagerException e) {
                log.warn("Error deleteting version " + versionId, (Throwable)e);
            }
        }
        log.info("Done.");
    }

    @Operation(summary="Fix the inconsistencies on HDFS")
    @GetMapping(value={"/hdfs/inconsistencies"})
    public Set<String> fixHdfsInconsistencies(@Parameter(name="force the deletion of hdfs paths") @RequestParam(required=false, defaultValue="false") boolean delete) throws MDStoreManagerException {
        Set hdfsDirs = this.hdfsClient.listHadoopDirs();
        Set validDirs = this.databaseUtils.listValidHdfsPaths();
        Sets.SetView toDelete = Sets.difference((Set)hdfsDirs, (Set)validDirs);
        log.info("Found " + toDelete.size() + " hdfs paths to remove");
        if (delete) {
            for (String p : toDelete) {
                this.hdfsClient.deletePath(p);
            }
        }
        return toDelete;
    }

    @Operation(summary="Show informations")
    @GetMapping(value={"/info"})
    public Map<String, Object> info() {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put("number_of_mdstores", this.databaseUtils.countMdStores());
        info.put("hadoop_user", this.hdfsClient.getHadoopUser());
        info.put("hadoop_cluster", this.hdfsClient.getHadoopCluster());
        info.put("hdfs_base_path", this.databaseUtils.getHdfsBasePath());
        info.put("expired_versions", this.databaseUtils.listExpiredVersions());
        return info;
    }

    @Operation(summary="list the file inside the path of a mdstore version")
    @GetMapping(value={"/version/{versionId}/parquet/files"})
    public Set<String> listVersionFiles(@PathVariable String versionId) throws MDStoreManagerException {
        String path = this.databaseUtils.findVersion(versionId).getHdfsPath();
        return this.hdfsClient.listContent(path + "/store", HdfsClient::isParquetFile);
    }

    @Operation(summary="read the parquet file of a mdstore version")
    @GetMapping(value={"/version/{versionId}/parquet/content/{limit}"})
    public List<Map<String, String>> listVersionParquet(@PathVariable String versionId, @PathVariable long limit) throws MDStoreManagerException {
        String path = this.databaseUtils.findVersion(versionId).getHdfsPath();
        return this.hdfsClient.readParquetFiles(path + "/store", limit);
    }

    @Operation(summary="read the parquet file of a mdstore (current version)")
    @GetMapping(value={"/mdstore/{mdId}/parquet/content/{limit}"})
    public List<Map<String, String>> listMdstoreParquet(@PathVariable String mdId, @PathVariable long limit) throws MDStoreManagerException {
        String versionId = this.databaseUtils.findMdStore(mdId).getCurrentVersion();
        String path = this.databaseUtils.findVersion(versionId).getHdfsPath();
        return this.hdfsClient.readParquetFiles(path + "/store", limit);
    }

    protected void setDatabaseUtils(DatabaseUtils databaseUtils) {
        this.databaseUtils = databaseUtils;
    }

    protected void setHdfsClient(HdfsClient hdfsClient) {
        this.hdfsClient = hdfsClient;
    }
}

