package eu.dnetlib.data.mdstore.manager.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;

@Component
@Profile("dev")
public class HdfsClientMock implements HdfsClient {

	private static final Log log = LogFactory.getLog(HdfsClientMock.class);

	@Override
	public String getHadoopUser() {
		return "DEV-USER";
	}

	@Override
	public String getHadoopCluster() {
		return "MOCK-CLUSTER";
	}

	@Override

	public String getHdfsBasePath() {
		return "/tmp";
	}

	@Override
	public void deletePath(final String path) throws MDStoreManagerException {
		throw new MDStoreManagerException("NOT IMPLEMENTED");
	}

	@Override
	public Set<String> listHadoopDirs() {
		return new HashSet<String>();
	}

	@Override
	public Set<String> listContent(final String hdfsPath) {
		return new HashSet<String>();
	}

	@Override
	public List<Map<String, String>> readParquetFiles(final String hdfsPath, final long limit) throws MDStoreManagerException {

		try {
			final String xml = IOUtils.toString(getClass().getResourceAsStream("/sample/sample.xml"), StandardCharsets.UTF_8);
			final String report = IOUtils.toString(getClass().getResourceAsStream("/sample/sample_report.json"), StandardCharsets.UTF_8);

			return Stream.generate(UUID::randomUUID)
					.map(UUID::toString)
					.map(id -> {
						final Map<String, String> reports = new HashMap<>();
						reports.put("openaire4_0", report.replaceAll("__ORIGINAL_ID__", id));

						final Map<String, String> map = new HashMap<>();
						map.put("id", "test________::" + DigestUtils.md5Hex(id));
						map.put("originalId", id);
						map.put("body", xml.replaceAll("__ORIGINAL_ID__", id));
						map.put("dateOfCollection", Long.toString(new Date().getTime()));
						map.put("encoding", "XML");
						map.put("provenance", "{\"datasourceId\": \"openaire____::TEST\", \"datasourceName\": \"TEST Datasource\", \"nsPrefix\": \"test________\"}");
						try {
							map.put("validationResults", new ObjectMapper().writeValueAsString(reports));
						} catch (final JsonProcessingException e) {
							e.printStackTrace();
						}

						return map;
					})
					.limit(50)
					.collect(Collectors.toList());
		} catch (final IOException e) {
			throw new MDStoreManagerException(e);
		}

	}

}
