/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;
import eu.dnetlib.data.mdstore.manager.utils.HdfsClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import parquet.avro.AvroParquetReader;
import parquet.hadoop.ParquetReader;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Profile(value={"!dev"})
public class HdfsClientImpl
implements HdfsClient {
    @Value(value="${dhp.mdstore-manager.hadoop.cluster}")
    private String hadoopCluster;
    @Value(value="${dhp.mdstore-manager.hadoop.user}")
    private String hadoopUser;
    @Value(value="${dhp.mdstore-manager.hdfs.base-path}")
    private String hdfsBasePath;
    private static final Log log = LogFactory.getLog(HdfsClientImpl.class);

    public void deletePath(String path) throws MDStoreManagerException {
        try (FileSystem fs = FileSystem.get((Configuration)this.conf());){
            fs.delete(new Path(path), true);
            log.info((Object)("HDFS Path deleted: " + path));
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Missing path: " + this.hdfsBasePath));
        }
        catch (IOException | IllegalArgumentException e) {
            log.error((Object)("Eror deleting path: " + path), (Throwable)e);
            throw new MDStoreManagerException("Eror deleting path: " + path, (Throwable)e);
        }
    }

    public Set<String> listHadoopDirs() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        try (FileSystem fs = FileSystem.get((Configuration)this.conf());){
            for (FileStatus mdDir : fs.listStatus(new Path(this.hdfsBasePath))) {
                if (!HdfsClientImpl.isMdStoreOrVersionDir((FileStatus)mdDir)) continue;
                res.add(String.format("%s/%s", this.hdfsBasePath, mdDir.getPath().getName()));
                for (FileStatus verDir : fs.listStatus(mdDir.getPath())) {
                    if (!HdfsClientImpl.isMdStoreOrVersionDir((FileStatus)verDir)) continue;
                    res.add(String.format("%s/%s/%s", this.hdfsBasePath, mdDir.getPath().getName(), verDir.getPath().getName()));
                }
            }
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Missing path: " + this.hdfsBasePath));
        }
        catch (Exception e) {
            log.error((Object)("Error Listing path: " + this.hdfsBasePath), (Throwable)e);
        }
        return res;
    }

    public Set<String> listContent(String path) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        try (FileSystem fs = FileSystem.get((Configuration)this.conf());){
            for (FileStatus f : fs.listStatus(new Path(path))) {
                if (!HdfsClientImpl.isParquetFile((FileStatus)f)) continue;
                res.add(String.format("%s/%s", path, f.getPath().getName()));
            }
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Missing path: " + this.hdfsBasePath));
        }
        catch (Exception e) {
            log.error((Object)("Error Listing path: " + path), (Throwable)e);
        }
        return res;
    }

    public List<Map<String, String>> readParquetFiles(String path, long limit) throws MDStoreManagerException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Configuration conf = this.conf();
        long i = 0L;
        LinkedHashSet fields = new LinkedHashSet();
        for (String f : this.listContent(path)) {
            if (i >= limit) continue;
            log.info((Object)("Opening parquet file: " + f));
            try {
                ParquetReader reader = AvroParquetReader.builder((Path)new Path(f)).withConf(conf).build();
                Throwable throwable = null;
                try {
                    log.debug((Object)"File parquet OPENED");
                    GenericRecord rec = null;
                    while (i++ < limit && (rec = (GenericRecord)reader.read()) != null) {
                        if (fields.isEmpty()) {
                            rec.getSchema().getFields().forEach(field -> fields.add(field.name()));
                            log.debug((Object)("Found schema: " + fields));
                        }
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        for (String field2 : fields) {
                            Object v = rec.get(field2);
                            if ("validationResults".equals(field2)) {
                                HashMap<String, String> reports = new HashMap<String, String>();
                                if (v != null) {
                                    for (Map.Entry e : ((Map)v).entrySet()) {
                                        if (e.getKey() == null || e.getValue() == null) continue;
                                        reports.put(e.getKey().toString(), e.getValue().toString());
                                    }
                                }
                                map.put(field2, new ObjectMapper().writeValueAsString(reports));
                                continue;
                            }
                            map.put(field2, v != null ? v.toString() : "");
                        }
                        list.add(map);
                        log.debug((Object)"added record");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Missing path: " + this.hdfsBasePath));
            }
            catch (Throwable e) {
                log.error((Object)("Error reading parquet file: " + f), e);
                throw new MDStoreManagerException("Error reading parquet file: " + f, e);
            }
        }
        return list;
    }

    public static boolean isParquetFile(FileStatus fileStatus) {
        return fileStatus.isFile() && fileStatus.getPath().getName().endsWith(".parquet");
    }

    public static boolean isMdStoreOrVersionDir(FileStatus fileStatus) {
        return fileStatus.isDirectory() && fileStatus.getPath().getName().startsWith("md-");
    }

    private Configuration conf() throws MDStoreManagerException {
        Configuration conf = new Configuration();
        System.setProperty("HADOOP_USER_NAME", this.hadoopUser);
        if ("OCEAN".equalsIgnoreCase(this.hadoopCluster)) {
            conf.addResource(this.getClass().getResourceAsStream("/hadoop/OCEAN/core-site.xml"));
            conf.addResource(this.getClass().getResourceAsStream("/hadoop/OCEAN/ocean-hadoop-conf.xml"));
        } else if ("GARR".equalsIgnoreCase(this.hadoopCluster)) {
            conf.addResource(this.getClass().getResourceAsStream("/hadoop/GARR/core-site.xml"));
            conf.addResource(this.getClass().getResourceAsStream("/hadoop/GARR/garr-hadoop-conf.xml"));
        } else if (!"MOCK".equalsIgnoreCase(this.hadoopCluster)) {
            log.error((Object)("Invalid Haddop Cluster: " + this.hadoopCluster));
            throw new MDStoreManagerException("Invalid Haddop Cluster: " + this.hadoopCluster);
        }
        return conf;
    }

    public String getHadoopCluster() {
        return this.hadoopCluster;
    }

    public void setHadoopCluster(String hadoopCluster) {
        this.hadoopCluster = hadoopCluster;
    }

    public String getHadoopUser() {
        return this.hadoopUser;
    }

    public void setHadoopUser(String hadoopUser) {
        this.hadoopUser = hadoopUser;
    }

    public String getHdfsBasePath() {
        return this.hdfsBasePath;
    }

    public void setHdfsBasePath(String hdfsBasePath) {
        this.hdfsBasePath = hdfsBasePath;
    }
}

