package eu.dnetlib.app.directindex;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@Profile("http-basic-security")
public class HttpBasicSecurityConfig {

	@Value("${dnet.directindex.auth.client.user}")
	private String clientUser;

	@Value("${dnet.directindex.auth.client.password}")
	private String clientPassword;

	@Value("${dnet.directindex.auth.admin.user}")
	private String adminUser;

	@Value("${dnet.directindex.auth.admin.password}")
	private String adminPassword;

	@Bean
	public InMemoryUserDetailsManager userDetailsService() {

		final UserDetails client = User.withUsername(clientUser)
				.password(clientPassword)
				.roles("USER")
				.build();

		final UserDetails admin = User.withUsername(adminUser)
				.password(adminPassword)
				.roles("USER", "ADMIN")
				.build();

		return new InMemoryUserDetailsManager(client, admin);
	}

	@Bean
	public SecurityFilterChain filterChain(final HttpSecurity http) throws Exception {
		http.httpBasic()
				.and()
				.authorizeRequests()
				.antMatchers("/api/results/**")
				.hasRole("USER")
				.antMatchers("/api/sword/**")
				.hasRole("USER")
				.antMatchers("/api/admin/**")
				.hasRole("ADMIN")
				.and()
				.csrf()
				.disable()
				.formLogin()
				.disable();

		return http.build();
	}

}
