/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.sword.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.app.directindex.sword.model.SwordCommonInfo;
import eu.dnetlib.app.directindex.sword.model.SwordLink;
import eu.dnetlib.app.directindex.sword.model.SwordState;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SwordStatusDocument
extends SwordCommonInfo {
    @JsonProperty(value="@context")
    private final String context = "https://swordapp.github.io/swordv3/swordv3.jsonld";
    @JsonProperty(value="@type")
    private final String type = "Status";
    private SwordCommonInfo metadata;
    private SwordCommonInfo fileSet;
    private String service;
    private SwordState state;
    private final LinkedHashMap<String, Boolean> actions = new LinkedHashMap();
    private final List<SwordLink> links = new ArrayList();

    public static SwordStatusDocument newInstance(String swordApiBaseUrl, String openaireId) {
        SwordStatusDocument status = new SwordStatusDocument();
        status.setId(swordApiBaseUrl + "/" + openaireId);
        status.setMetadata(new SwordCommonInfo(swordApiBaseUrl + "/" + openaireId + "/metadata"));
        status.setFileSet(null);
        status.setService(swordApiBaseUrl);
        status.setState(SwordState.inProgress);
        status.getActions().put("getMetadata", true);
        status.getActions().put("getFiles", false);
        status.getActions().put("appendMetadata", true);
        status.getActions().put("appendFiles", false);
        status.getActions().put("replaceMetadata", true);
        status.getActions().put("replaceFiles", false);
        status.getActions().put("deleteMetadata", false);
        status.getActions().put("deleteFiles", false);
        status.getActions().put("deleteObject", true);
        status.getLinks().add(SwordLink.newOpenaireLink((String)openaireId));
        return status;
    }

    public SwordCommonInfo getMetadata() {
        return this.metadata;
    }

    public void setMetadata(SwordCommonInfo metadata) {
        this.metadata = metadata;
    }

    public SwordCommonInfo getFileSet() {
        return this.fileSet;
    }

    public void setFileSet(SwordCommonInfo fileSet) {
        this.fileSet = fileSet;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Object getState() {
        return this.state;
    }

    public void setState(SwordState state) {
        this.state = state;
    }

    public String getType() {
        return "Status";
    }

    public LinkedHashMap<String, Boolean> getActions() {
        return this.actions;
    }

    public List<SwordLink> getLinks() {
        return this.links;
    }
}

