package eu.dnetlib.app.directindex.controllers;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import eu.dnetlib.app.directindex.clients.HasCache;
import eu.dnetlib.app.directindex.service.DirectIndexService;
import eu.dnetlib.app.directindex.tasks.ScheduledActions;

@RestController
@RequestMapping("/api/admin")
public class AdminController {

	@Autowired
	private ScheduledActions scheduledActions;

	@Autowired
	private DirectIndexService service;

	@Autowired
	private List<HasCache> clients;

	@GetMapping("/info")
	public Map<String, ?> info() {
		return service.getInfo();
	}

	@DeleteMapping("/other-caches")
	@ResponseStatus(HttpStatus.OK)
	public void evictCaches() {
		clients.forEach(HasCache::clearCache);
	}

	@GetMapping("/scheduling/{enabled}")
	@ResponseStatus(HttpStatus.OK)
	public void updateScheduling(@PathVariable final boolean enabled) {
		scheduledActions.setEnabled(enabled);
	}

	@GetMapping("/resetExecutions/all")
	@ResponseStatus(HttpStatus.OK)
	public void resetExecutions() {
		service.resetExecutions();
	}

	@GetMapping("/resetExecutions/byDateAfter")
	@ResponseStatus(HttpStatus.OK)
	public void resetExecutions(@RequestParam final LocalDateTime datetime) {
		service.resetExecutions(datetime);
	}

	@GetMapping("/resetExecutions/byId")
	@ResponseStatus(HttpStatus.OK)
	public void resetExecutions(@RequestParam final String id) {
		service.resetExecutions(id);
	}

	@DeleteMapping("/records-cache/byDateBefore")
	@ResponseStatus(HttpStatus.OK)
	public void deleteExpiredRecords(@RequestParam final LocalDateTime datetime) {
		service.clearDatabase(datetime);
	}

	@DeleteMapping("/records-cache/all")
	@ResponseStatus(HttpStatus.OK)
	public void deleteExpiredRecords() {
		service.clearDatabase();
	}

	@DeleteMapping("/records-cache/byId")
	@ResponseStatus(HttpStatus.OK)
	public void deleteExpiredRecords(@RequestParam final String id) {
		service.clearDatabase(id);
	}

}
