/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.solr;

import eu.dnetlib.app.directindex.solr.SolrIndexClient;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SolrIndexClientFactory {
    private static final Log log = LogFactory.getLog(SolrIndexClientFactory.class);
    public static final String CHROOT_SEPARATOR = "/";
    @Value(value="${dnet.directindex.solr.urls}")
    public String solrUrls;
    @Value(value="${dnet.directindex.solr.collection}")
    public String solrCollection;
    @Value(value="${dnet.directindex.solr.client}")
    public String solrClientType;
    @Value(value="${dnet.directindex.solr.zk_chroot}")
    public String solrZkChroot;

    public SolrIndexClient getClient() {
        SolrClient client;
        switch (this.solrClientType.toUpperCase()) {
            case "LBHTTP1": {
                client = this.getLoadBalancedHttp1Client(this.solrUrls, this.solrCollection);
                break;
            }
            case "LBHTTP2": {
                client = this.getLoadBalancedHttp2Client(this.solrUrls, this.solrCollection);
                break;
            }
            case "CLOUD": {
                client = this.getCloudClient(this.solrUrls, this.solrCollection);
                break;
            }
            case "ZK_CLOUD": {
                client = this.getZKCloudClient(this.solrUrls, this.solrCollection, Optional.of(this.solrZkChroot));
                break;
            }
            default: {
                client = this.getSimpleClient(this.solrUrls, this.solrCollection);
            }
        }
        return new SolrIndexClient(client);
    }

    @Deprecated
    protected SolrClient getLoadBalancedHttp1Client(String urls, String coll) {
        log.warn((Object)String.format("Initializing deprecated solr client (Load Balanced HTTP/1), urls: %s, collection: %s", urls, coll));
        String[] endpoints = (String[])Arrays.stream(urls.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(url -> {
            url = (String)url + CHROOT_SEPARATOR + coll;
            return url;
        }).toArray(String[]::new);
        return ((LBHttpSolrClient.Builder)new LBHttpSolrClient.Builder().withHttpClient((HttpClient)new DefaultHttpClient())).withBaseEndpoints(endpoints).build();
    }

    protected SolrClient getLoadBalancedHttp2Client(String urls, String coll) {
        log.debug((Object)String.format("Initializing solr client (Load Balanced HTTP/2), urls: %s, collection: %s", urls, coll));
        LBSolrClient.Endpoint[] endpoints = (LBSolrClient.Endpoint[])Arrays.stream(urls.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(url -> {
            url = (String)url + CHROOT_SEPARATOR + coll;
            return url;
        }).map(LBSolrClient.Endpoint::new).toArray(LBSolrClient.Endpoint[]::new);
        Http2SolrClient http2SolrClient = new Http2SolrClient.Builder().build();
        return new LBHttp2SolrClient.Builder(http2SolrClient, endpoints).build();
    }

    private SolrClient getCloudClient(String urls, String coll) {
        log.debug((Object)String.format("Initializing solr client (cloud), urls: %s, collection: %s", urls, coll));
        List<String> urlList = Arrays.stream(urls.split(",")).map(String::trim).filter(StringUtils::isNotBlank).toList();
        return new CloudSolrClient.Builder(urlList).withParallelUpdates(true).withDefaultCollection(coll).build();
    }

    protected SolrClient getZKCloudClient(String urls, String coll, Optional<String> chroot) {
        log.debug((Object)String.format("Initializing solr client (cloud), urls: %s, collection: %s", urls, coll));
        List<String> urlList = Arrays.stream(urls.split(",")).map(String::trim).filter(StringUtils::isNotBlank).toList();
        return new CloudSolrClient.Builder(urlList, chroot).withParallelUpdates(true).withDefaultCollection(coll).build();
    }

    protected SolrClient getSimpleClient(String url, String coll) {
        log.debug((Object)String.format("Initializing solr client (SIMPLE), url: %s, collection: %s", url, coll));
        LBSolrClient.Endpoint endpoint = new LBSolrClient.Endpoint(url.trim() + CHROOT_SEPARATOR + coll);
        Http2SolrClient http2SolrClient = new Http2SolrClient.Builder().build();
        return new LBHttp2SolrClient.Builder(http2SolrClient, new LBSolrClient.Endpoint[]{endpoint}).build();
    }
}

