package eu.dnetlib.app.directindex.sword.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SwordStatusDocument extends SwordCommonInfo {

	@JsonProperty("@context")
	private final String context = "https://swordapp.github.io/swordv3/swordv3.jsonld";

	@JsonProperty("@type")
	private final String type = "Status";

	private SwordCommonInfo metadata;

	private SwordCommonInfo fileSet;

	private String service;

	private SwordState state;

	private final LinkedHashMap<String, Boolean> actions = new LinkedHashMap<String, Boolean>();

	private final List<SwordLink> links = new ArrayList<>();

	public static SwordStatusDocument newInstance(final String swordApiBaseUrl, final String openaireId) {

		final SwordStatusDocument status = new SwordStatusDocument();

		status.setId(swordApiBaseUrl + "/" + openaireId);
		status.setMetadata(new SwordCommonInfo(swordApiBaseUrl + "/" + openaireId + "/metadata"));
		status.setFileSet(null);
		status.setService(swordApiBaseUrl);
		status.setState(SwordState.inProgress);
		status.getActions().put("getMetadata", true);
		status.getActions().put("getFiles", false);
		status.getActions().put("appendMetadata", true);
		status.getActions().put("appendFiles", false);
		status.getActions().put("replaceMetadata", true);
		status.getActions().put("replaceFiles", false);
		status.getActions().put("deleteMetadata", false);
		status.getActions().put("deleteFiles", false);
		status.getActions().put("deleteObject", true);
		status.getLinks().add(SwordLink.newOpenaireLink(openaireId));

		return status;
	}

	public SwordCommonInfo getMetadata() {
		return metadata;
	}

	public void setMetadata(final SwordCommonInfo metadata) {
		this.metadata = metadata;
	}

	public SwordCommonInfo getFileSet() {
		return fileSet;
	}

	public void setFileSet(final SwordCommonInfo fileSet) {
		this.fileSet = fileSet;
	}

	public String getService() {
		return service;
	}

	public void setService(final String service) {
		this.service = service;
	}

	public Object getState() {
		return state;
	}

	public void setState(final SwordState state) {
		this.state = state;
	}

	public String getType() {
		return type;
	}

	public LinkedHashMap<String, Boolean> getActions() {
		return actions;
	}

	public List<SwordLink> getLinks() {
		return links;
	}
}
