package eu.dnetlib.app.directindex.sword.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.http.MediaType;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SwordLink {

	@JsonProperty("@id")
	private String id;

	private List<String> rel = new ArrayList<>();

	private String contentType;

	public static SwordLink newOpenaireLink(final String openaireId) {
		final SwordLink link = new SwordLink();

		link.setId("https://explore.openaire.eu/search/publication?articleId=" + openaireId);
		link.setContentType(MediaType.TEXT_HTML_VALUE);
		link.setRel(Arrays.asList("alternate"));

		return null;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public List<String> getRel() {
		return rel;
	}

	public void setRel(final List<String> rel) {
		this.rel = rel;
	}

	public String getContentType() {
		return contentType;
	}

	public void setContentType(final String contentType) {
		this.contentType = contentType;
	}

}
