package eu.dnetlib.app.directindex.sword.model;

import java.util.Arrays;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

// TODO: Controllare il documento

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SwordServiceDocument {

	private static final SwordIdDescProperty DEFAULT_COLLECTION_POLICY = new SwordIdDescProperty("http://TODO", "Collection Policy Of ....");;

	private static final SwordIdDescProperty DEFAULT_TREATMENT = new SwordIdDescProperty("http://TODO", "Traeatment Of ....");

	@JsonProperty("@context")
	public final String context = "https://swordapp.github.io/swordv3/swordv3.jsonld";

	@JsonProperty("@id")
	public String id;

	@JsonProperty("@type")
	public final String type = "ServiceDocument";

	@JsonProperty("dc:title")
	public String title;

	@JsonProperty("dcterms:abstract")
	public String description;

	public String root;
	public final boolean acceptDeposits = true;
	public final String version = "http://purl.org/net/sword/3.0";
	public final long maxUploadSize = 0;
	public final long maxByReferenceSize = 0;
	public final long maxSegmentSize = 0;
	public final long minSegmentSize = 0;
	public final long maxAssembledSize = 0;
	public final long maxSegments = 0;

	public final List<String> accept = Arrays.asList("*/*");
	public final List<String> acceptArchiveFormat = Arrays.asList();
	public final List<String> acceptPackaging = Arrays.asList();
	public final List<String> acceptMetadata = Arrays.asList("OAF");

	public final SwordIdDescProperty collectionPolicy = DEFAULT_COLLECTION_POLICY;
	public final SwordIdDescProperty treatment = DEFAULT_TREATMENT;

	public final String staging = null;
	public final long stagingMaxIdle = 0;

	public final boolean byReferenceDeposit = false;
	public final boolean onBehalfOf = false;

	public final List<String> digest = Arrays.asList("md5", "sha-256");
	public final List<String> authentication = Arrays.asList();
	public final List<SwordService> services = Arrays.asList();

	public static SwordServiceDocument newInstance(final String serviceDocId, final String title, final String desc) {
		final SwordServiceDocument doc = new SwordServiceDocument();
		doc.setId(serviceDocId);
		doc.setRoot(serviceDocId);
		doc.setTitle(title);
		doc.setDescription(desc);
		return doc;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public String getRoot() {
		return root;
	}

	public void setRoot(final String root) {
		this.root = root;
	}

	public String getContext() {
		return context;
	}

	public String getType() {
		return type;
	}

	public boolean isAcceptDeposits() {
		return acceptDeposits;
	}

	public String getVersion() {
		return version;
	}

	public long getMaxUploadSize() {
		return maxUploadSize;
	}

	public long getMaxByReferenceSize() {
		return maxByReferenceSize;
	}

	public long getMaxSegmentSize() {
		return maxSegmentSize;
	}

	public long getMinSegmentSize() {
		return minSegmentSize;
	}

	public long getMaxAssembledSize() {
		return maxAssembledSize;
	}

	public long getMaxSegments() {
		return maxSegments;
	}

	public List<String> getAccept() {
		return accept;
	}

	public List<String> getAcceptArchiveFormat() {
		return acceptArchiveFormat;
	}

	public List<String> getAcceptPackaging() {
		return acceptPackaging;
	}

	public List<String> getAcceptMetadata() {
		return acceptMetadata;
	}

	public SwordIdDescProperty getCollectionPolicy() {
		return collectionPolicy;
	}

	public SwordIdDescProperty getTreatment() {
		return treatment;
	}

	public String getStaging() {
		return staging;
	}

	public long getStagingMaxIdle() {
		return stagingMaxIdle;
	}

	public boolean isByReferenceDeposit() {
		return byReferenceDeposit;
	}

	public boolean isOnBehalfOf() {
		return onBehalfOf;
	}

	public List<String> getDigest() {
		return digest;
	}

	public List<String> getAuthentication() {
		return authentication;
	}

	public List<SwordService> getServices() {
		return services;
	}

	// @formatter:off

	/*
	{
		  "@context" : "https://swordapp.github.io/swordv3/swordv3.jsonld",

		  "@id" : "http://example.com/service-document",
		  "@type" : "ServiceDocument",

		  "dc:title" : "Site Name",
		  "dcterms:abstract" : "Site Description",

		  "root" : "http://example.com/service-document",
		  "acceptDeposits": true,

		  "version": "http://purl.org/net/sword/3.0",
		  "maxUploadSize" : 16777216000,
		  "maxByReferenceSize" : 30000000000000000,
		  "maxSegmentSize" : 16777216000,
		  "minSegmentSize" : 1,
		  "maxAssembledSize" : 30000000000000,
		  "maxSegments" : 1000,

		  "accept" : ["* /*"],
		  "acceptArchiveFormat" : ["application/zip"],
		  "acceptPackaging" : ["*"],
		  "acceptMetadata" : ["http://purl.org/net/sword/3.0/types/Metadata"],

		  "collectionPolicy" : {
		    "@id" : "http://www.myorg.ac.uk/collectionpolicy",
		    "description" : "...."
		  },
		  "treatment" : {
		    "@id" : "http://www.myorg.ac.uk/treatment",
		    "description" : "..."
		  },

		  "staging" : "http://example.com/staging",
		  "stagingMaxIdle" : 3600,

		  "byReferenceDeposit" : true,
		  "onBehalfOf" : true,

		  "digest" : ["SHA-256", "SHA", "MD5"],
		  "authentication": ["Basic", "OAuth", "Digest", "APIKey"],

		  "services" : [
		    {
		      "@id": "http://swordapp.org/deposit/43",

		      "dc:title" : "Deposit Service Name",
		      "dcterms:abstract" : "Deposit Service Description",

		      "root" : "http://example.com/service-document",
		      "parent" : "http://example.com/service-document",
		      "acceptDeposits": true,

		      "services" : []
		    }
		  ]
		}

 */
}
