/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.repo;

import eu.dnetlib.app.directindex.repo.OperationType;
import eu.dnetlib.app.directindex.repo.PendingAction;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface PendingActionRepository
extends JpaRepository<PendingAction, String> {
    @Query(value="select * from pending_actions where execution_date is null and (upper(operation) = 'INSERT' or upper(operation) = 'UPDATE')", nativeQuery=true)
    public List<PendingAction> findInsertOrUpdateOperations();

    @Query(value="select * from pending_actions where execution_date is null and upper(operation) = 'DELETE'", nativeQuery=true)
    public List<PendingAction> findDeleteOperations();

    public void deleteByCreationDateBefore(LocalDateTime var1);

    @Modifying
    @Query(value="update pending_actions set execution_date = null", nativeQuery=true)
    public void resetAllExecutions();

    @Modifying
    @Query(value="update pending_actions set execution_date = null where creation_date > ? and body::::jsonb->>'collectedFromId'::::text = ?", nativeQuery=true)
    public void resetExecutionsForAllTypes(LocalDateTime var1, String var2);

    @Modifying
    @Query(value="update pending_actions set execution_date = null where creation_date > ? and body::::jsonb->>'collectedFromId'::::text = ? and type = ?", nativeQuery=true)
    public void resetExecutionsForType(LocalDateTime var1, String var2, String var3);

    @Modifying
    @Query(value="update pending_actions set execution_date = null where id = ?", nativeQuery=true)
    public void resetExecutionForId(String var1);

    public long countByExecutionDateIsNull();

    public long countByOperation(OperationType var1);

    public long countByOperationAndExecutionDateIsNull(OperationType var1);

    @Query(value="select min(creation_date) from pending_actions", nativeQuery=true)
    public LocalDateTime findMinCreationDate();

    @Query(value="select max(creation_date) from pending_actions", nativeQuery=true)
    public LocalDateTime findMaxCreationDate();

    @Query(value="select min(execution_date) from pending_actions", nativeQuery=true)
    public LocalDateTime findMinExecutionDate();

    @Query(value="select max(execution_date) from pending_actions", nativeQuery=true)
    public LocalDateTime findMaxExecutionDate();

    public long countByErrorIsNotNull();

    @Modifying
    @Query(value="delete from pending_actions where EXTRACT(DAY from now()-creation_date) > ?", nativeQuery=true)
    public void deleteObsoleteRecords(int var1);
}

