/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.service;

import eu.dnetlib.app.directindex.clients.DatasourceManagerClient;
import eu.dnetlib.app.directindex.errors.DirectIndexApiException;
import eu.dnetlib.app.directindex.input.DatasourceEntry;
import eu.dnetlib.app.directindex.input.ResultEntry;
import eu.dnetlib.app.directindex.repo.OperationType;
import eu.dnetlib.app.directindex.repo.PendingAction;
import eu.dnetlib.app.directindex.repo.PendingActionRepository;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DirectIndexService {
    private static final DatasourceEntry UNKNOWN_REPO = new DatasourceEntry("openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18", "Unknown Repository", "unknown_____");
    @Autowired
    private PendingActionRepository pendingActionRepository;
    @Autowired
    private DatasourceManagerClient dsmClient;

    @Transactional
    public Optional<PendingAction> findPendingAction(String id) {
        return this.pendingActionRepository.findById((Object)id);
    }

    @Transactional
    public void prepareMetadataDeletion(String openaireId, String createdBy) {
        PendingAction action = new PendingAction();
        action.setId(openaireId);
        action.setOperation(OperationType.DELETE);
        action.setCreatedBy(createdBy);
        action.setCreationDate(LocalDateTime.now());
        action.setExecutionDate(null);
        this.pendingActionRepository.save((Object)action);
    }

    @Transactional
    public String prepareMetadataInsertOrUpdate(ResultEntry r, String createdBy) throws DirectIndexApiException {
        PendingAction info = new PendingAction();
        if (StringUtils.isNotBlank((CharSequence)r.getOpenaireId())) {
            if (!r.getOpenaireId().matches("^\\w{12}::\\w{32}$")) {
                throw new DirectIndexApiException("Invalid openaireId: " + r.getOpenaireId() + " - regex ^\\w{12}::\\w{32}$ not matched");
            }
            info.setOperation(OperationType.UPDATE);
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{r.getOriginalId(), r.getCollectedFromId()})) {
            this.fixOpenaireId(r);
            info.setOperation(OperationType.INSERT);
        } else {
            throw new DirectIndexApiException("Missing identifier fields: [openaireId] or [originalId, collectedFromId]");
        }
        if (StringUtils.isBlank((CharSequence)r.getTitle())) {
            throw new DirectIndexApiException("A required field is missing: title");
        }
        if (StringUtils.isBlank((CharSequence)r.getUrl())) {
            throw new DirectIndexApiException("A required field is missing: url");
        }
        if (StringUtils.isBlank((CharSequence)r.getAccessRightCode())) {
            throw new DirectIndexApiException("A required field is missing: accessRightCode");
        }
        if (StringUtils.isBlank((CharSequence)r.getResourceType())) {
            throw new DirectIndexApiException("A required field is missing: resourceType");
        }
        if (StringUtils.isBlank((CharSequence)r.getCollectedFromId())) {
            throw new DirectIndexApiException("A required field is missing: collectedFromId");
        }
        if (StringUtils.isBlank((CharSequence)r.getType())) {
            throw new DirectIndexApiException("A required field is missing: type");
        }
        info.setId(r.getOpenaireId());
        info.setBody(r.toJson());
        info.setType(r.getType());
        info.setCreatedBy(createdBy);
        info.setCreationDate(LocalDateTime.now());
        info.setExecutionDate(null);
        this.pendingActionRepository.save((Object)info);
        return info.getId();
    }

    private void fixOpenaireId(ResultEntry r) throws DirectIndexApiException {
        DatasourceEntry ds = StringUtils.isNotBlank((CharSequence)r.getCollectedFromId()) ? this.dsmClient.findDatasource(r.getCollectedFromId()) : UNKNOWN_REPO;
        String openaireId = ds.getPrefix() + "::" + DigestUtils.md5Hex((String)r.getOriginalId());
        r.setOpenaireId(openaireId);
    }

    @Transactional
    public void clearDatabase() {
        this.pendingActionRepository.deleteAll();
    }

    @Transactional
    public void clearDatabase(String id) {
        this.pendingActionRepository.deleteById((Object)id);
    }

    @Transactional
    public void clearDatabase(LocalDateTime datetime) {
        this.pendingActionRepository.deleteByCreationDateBefore(datetime);
    }

    @Transactional
    public void resetExecutions() {
        this.pendingActionRepository.resetAllExecutions();
    }

    @Transactional
    public void resetExecutions(LocalDateTime byDatetimeAfter, String collectedFromId, String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            this.pendingActionRepository.resetExecutionsForAllTypes(byDatetimeAfter, collectedFromId);
        } else {
            this.pendingActionRepository.resetExecutionsForType(byDatetimeAfter, collectedFromId, type);
        }
    }

    @Transactional
    public void resetExecutions(String id) {
        this.pendingActionRepository.resetExecutionForId(id);
    }

    @Transactional
    public Map<String, ?> getInfo() {
        LinkedHashMap<String, Comparable<Long>> info = new LinkedHashMap<String, Comparable<Long>>();
        info.put("total_actions", Long.valueOf(this.pendingActionRepository.count()));
        info.put("total_actions_insert", Long.valueOf(this.pendingActionRepository.countByOperation(OperationType.INSERT)));
        info.put("total_actions_update", Long.valueOf(this.pendingActionRepository.countByOperation(OperationType.UPDATE)));
        info.put("total_actions_delete", Long.valueOf(this.pendingActionRepository.countByOperation(OperationType.DELETE)));
        info.put("pending_actions", Long.valueOf(this.pendingActionRepository.countByExecutionDateIsNull()));
        info.put("pending_actions_insert", Long.valueOf(this.pendingActionRepository.countByOperationAndExecutionDateIsNull(OperationType.INSERT)));
        info.put("pending_actions_update", Long.valueOf(this.pendingActionRepository.countByOperationAndExecutionDateIsNull(OperationType.UPDATE)));
        info.put("pending_actions_delete", Long.valueOf(this.pendingActionRepository.countByOperationAndExecutionDateIsNull(OperationType.DELETE)));
        info.put("min_registration_date", this.pendingActionRepository.findMinCreationDate());
        info.put("max_registration_date", this.pendingActionRepository.findMaxCreationDate());
        info.put("min_execution_date", this.pendingActionRepository.findMinExecutionDate());
        info.put("max_execution_date", this.pendingActionRepository.findMaxExecutionDate());
        info.put("errors", Long.valueOf(this.pendingActionRepository.countByErrorIsNotNull()));
        return info;
    }
}

