/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import eu.dnetlib.app.directindex.input.ResultEntry;
import eu.dnetlib.app.directindex.mapping.SolrRecordMapper;
import eu.dnetlib.app.directindex.repo.PendingAction;
import eu.dnetlib.app.directindex.repo.PendingActionRepository;
import eu.dnetlib.app.directindex.solr.SolrIndexClient;
import eu.dnetlib.app.directindex.solr.SolrIndexClientFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledActions {
    private static final Log log = LogFactory.getLog(ScheduledActions.class);
    @Value(value="${dnet.directindex.scheduling.enabled}")
    private boolean enabled;
    @Autowired
    private SolrIndexClientFactory solrIndexClientFactory;
    @Autowired
    private SolrRecordMapper solrRecordMapper;
    @Autowired
    private PendingActionRepository pendingActionRepository;
    @Value(value="${dnet.directindex.scheduling.nThreads}")
    private int nThreads;
    @Value(value="${dnet.directindex.scheduling.maxActionsForThread}")
    private int maxActionsForThread;
    @Value(value="${dnet.directindex.maxNumberOfDays}")
    private int maxNumberOfDays;

    @Scheduled(initialDelay=1L, fixedDelayString="${dnet.directindex.scheduling.upsert.interval}", timeUnit=TimeUnit.MINUTES)
    public synchronized void indexRecords() throws InterruptedException {
        if (!this.enabled) {
            log.debug((Object)"SKIP");
            return;
        }
        Instant start = Instant.now();
        List list = this.pendingActionRepository.findInsertOrUpdateOperations();
        if (list.isEmpty()) {
            return;
        }
        log.debug((Object)("Start Indexing new records, size=" + list.size()));
        ExecutorService executor = Executors.newFixedThreadPool(this.nThreads);
        Lists.partition((List)list, (int)this.maxActionsForThread).forEach(subList -> executor.execute(() -> this.indexRecords(subList)));
        executor.shutdown();
        if (executor.awaitTermination(20L, TimeUnit.MINUTES)) {
            long timeElapsed = Duration.between(start, Instant.now()).toSeconds() + 1L;
            log.info((Object)String.format("Indexed %s records in %d seconds (%.3f records/s)", list.size(), timeElapsed, Float.valueOf((float)list.size() / (float)timeElapsed)));
        } else {
            log.warn((Object)"Some threads continue to be running");
        }
    }

    private void indexRecords(List<PendingAction> list) {
        log.debug((Object)"(THREAD) Start indexing...");
        try {
            Instant start = Instant.now();
            HashMap invalids = new HashMap();
            SolrIndexClient solr = this.solrIndexClientFactory.getClient();
            ObjectMapper objectMapper = new ObjectMapper();
            Iterator iter = list.stream().map(pendingAction -> {
                String id = pendingAction.getId();
                String body = pendingAction.getBody();
                try {
                    ResultEntry resultEntry = (ResultEntry)objectMapper.readValue(body, ResultEntry.class);
                    SolrInputDocument doc = this.solrRecordMapper.toSolrInputRecord(resultEntry);
                    return doc;
                }
                catch (Throwable e) {
                    invalids.put(id, e.getClass().getName() + ": " + e.getMessage());
                    log.error((Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).iterator();
            solr.addRecords(iter);
            solr.commit();
            this.updateExecutionDate(list, invalids);
            long timeElapsed = Duration.between(start, Instant.now()).toSeconds() + 1L;
            log.debug((Object)String.format("(THREAD) Indexed %s records in %d seconds (%.3f records/s)", list.size(), timeElapsed, Float.valueOf((float)list.size() / (float)timeElapsed)));
        }
        catch (Throwable e) {
            log.error((Object)"(THREAD) Error indexing records", e);
        }
    }

    @Scheduled(initialDelay=5L, fixedDelayString="${dnet.directindex.scheduling.delete.interval}", timeUnit=TimeUnit.MINUTES)
    public synchronized void deleteRecords() {
        if (!this.enabled) {
            log.debug((Object)"SKIP");
            return;
        }
        try {
            List list = this.pendingActionRepository.findDeleteOperations();
            HashMap invalids = new HashMap();
            if (list.size() > 0) {
                log.debug((Object)("Start deleting records from index, size=" + list.size()));
                SolrIndexClient solr = this.solrIndexClientFactory.getClient();
                list.stream().map(PendingAction::getId).forEach(id -> {
                    try {
                        solr.deleteRecord(id);
                    }
                    catch (Throwable e) {
                        invalids.put(id, e.getMessage());
                        log.error((Object)e);
                    }
                });
                solr.commit();
                this.updateExecutionDate(list, invalids);
                log.info((Object)String.format("Deleted records: %s", list.size()));
            }
        }
        catch (Throwable e) {
            log.error((Object)"The scheduled task is failed", e);
        }
    }

    @Scheduled(initialDelay=1L, fixedDelay=24L, timeUnit=TimeUnit.HOURS)
    public synchronized void deleteObsoleteRecords() throws InterruptedException {
        log.info((Object)"Deleting obsoleted records from the cache");
        this.pendingActionRepository.deleteObsoleteRecords(this.maxNumberOfDays);
    }

    private void updateExecutionDate(List<PendingAction> list, Map<String, String> invalids) {
        LocalDateTime now = LocalDateTime.now();
        list.forEach(r -> {
            r.setError((String)invalids.getOrDefault(r.getId(), null));
            r.setExecutionDate(now);
        });
        this.pendingActionRepository.saveAll(list);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

