package eu.dnetlib.openaire.community.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

@Entity
@Table(name = "community_orgs")
@IdClass(DbOrganizationPK.class)
public class DbOrganization implements Serializable {

	private static final long serialVersionUID = -602114117980437763L;

	@Id
	@Column(name = "community")
	private String community;

	@Id
	@Column(name = "org_id")
	private String orgId;

	@Column(name = "description")
	private String description;

	@Column(name = "subscribed")
	private Boolean isSubscribed;

	public DbOrganization() {}

	public DbOrganization(final String community, final String orgId) {
		this.community = community;
		this.orgId = orgId;
		isSubscribed = false;
		description = null;
	}

	public String getCommunity() {
		return community;
	}

	public void setCommunity(final String community) {
		this.community = community;
	}

	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(final String orgId) {
		this.orgId = orgId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public Boolean getIsSubscribed() {
		return isSubscribed;
	}

	public void setIsSubscribed(final Boolean isSubscribed) {
		this.isSubscribed = isSubscribed;
	}

	@Override
	public String toString() {
		return String.format("DbOrganization [community=%s, orgId=%s, description=%s, isSubscribed=%s]", community, orgId, description, isSubscribed);
	}

}
