/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.community.CommunityService;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.exceptions.ResourceNotFoundException;
import eu.dnetlib.openaire.exporter.model.community.CommunityOpenAIRECommunities;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
@Tag(name="OpenAIRE Communities API", description="the OpenAIRE Community API")
public class OtherCommunityApiController
extends AbstractExporterController {
    @Autowired
    private CommunityService communityService;

    @GetMapping(value={"/propagationOrganizationCommunityMap"})
    @Operation(summary="Get the propagationOrganizationCommunityMap", description="Get the propagationOrganizationCommunityMap", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Map<String, Set<String>> getPropagationOrganizationCommunityMap() throws CommunityException {
        try {
            return this.communityService.getPropagationOrganizationCommunityMap();
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/datasourceCommunityMap"})
    @Operation(summary="Get the datasourceCommunityMap", description="Get the datasourceCommunityMap", tags={"Community content providers", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Map<String, Set<String>> getDatasourceCommunityMap() throws CommunityException {
        try {
            return this.communityService.getPropagationOrganizationCommunityMap();
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{zenodoId}/openairecommunities"})
    @Operation(summary="get the list of OpenAIRE communities associated to a given Zenodo community", description="get the list of OpenAIRE communities associated to a given Zenodo community", tags={"Community Zenodo Communities", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOpenAIRECommunities getOpenAireCommunities(@PathVariable String zenodoId) throws CommunityException {
        try {
            CommunityOpenAIRECommunities res = new CommunityOpenAIRECommunities();
            res.setZenodoid(zenodoId);
            res.setOpenAirecommunitylist(this.communityService.getOpenAIRECommunitiesByZenodoId(zenodoId));
            return res;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }
}

