/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.project;

import com.google.common.xml.XmlEscapers;
import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.project.ProjectQueryParams;
import eu.dnetlib.openaire.project.ProjectQueryParamsFactory;
import eu.dnetlib.openaire.project.dao.JdbcApiDao;
import eu.dnetlib.openaire.project.dao.ValueCleaner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.project"}, havingValue="true")
@Tag(name="OpenAIRE projects API", description="the OpenAIRE projects API")
public class ProjectsController
extends AbstractExporterController {
    private static final Log log = LogFactory.getLog(ProjectsController.class);
    public static final String UTF8 = "UTF-8";
    @Autowired
    private DnetOpenaireExporterProperties config;
    @Autowired
    private JdbcApiDao dao;
    @Autowired
    private ProjectQueryParamsFactory projectQueryParamsFactory;

    @RequestMapping(value={"/export/**/project/dspace.do"}, method={RequestMethod.GET})
    @Operation(summary="DSpace", description="return project information in compatible with the OpenAIRE plugin for DSpace", tags={"DSpace"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void processDspace(HttpServletRequest request, ServletResponse response, @RequestParam(value="startFrom", required=false) String startFrom, @RequestParam(value="startUntil", required=false) String startUntil, @RequestParam(value="endFrom", required=false) String endFrom, @RequestParam(value="endUntil", required=false) String endUntil) throws Exception {
        DnetOpenaireExporterProperties.Project conf = this.config.getProject();
        ProjectQueryParams params = this.projectQueryParamsFactory.generateParams(request, startFrom, startUntil, endFrom, endUntil);
        StringTemplate headSt = new StringTemplate(IOUtils.toString((InputStream)conf.getDspaceHeadTemplate().getInputStream(), (String)UTF8));
        headSt.setAttribute("fundingProgramme", (Object)params.getFundingProgramme());
        StringTemplate tailSt = new StringTemplate(IOUtils.toString((InputStream)conf.getDspaceTailTemplate().getInputStream(), (String)UTF8));
        response.setContentType("text/xml");
        this.doProcess(response, params, headSt.toString(), conf.getDspaceTemplate(), tailSt.toString(), s -> XmlEscapers.xmlContentEscaper().escape(this.oneLiner(s)));
    }

    @RequestMapping(value={"/export/**/project/eprints.do"}, method={RequestMethod.GET})
    @Operation(summary="EPrints", description="return project information in compatible with the OpenAIRE plugin for Eprints", tags={"EPrints"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void processEprints(HttpServletRequest request, ServletResponse response, @RequestParam(value="startFrom", required=false) String startFrom, @RequestParam(value="startUntil", required=false) String startUntil, @RequestParam(value="endFrom", required=false) String endFrom, @RequestParam(value="endUntil", required=false) String endUntil) throws Exception {
        ProjectQueryParams params = this.projectQueryParamsFactory.generateParams(request, startFrom, startUntil, endFrom, endUntil);
        response.setContentType("text/html");
        this.doProcess(response, params, null, this.config.getProject().getEprintsTemplate(), null, arg_0 -> this.oneLiner(arg_0));
    }

    private String oneLiner(String s) {
        return StringUtils.isNotBlank((CharSequence)s) ? s.replaceAll("\\n", " ").trim() : "";
    }

    private void doProcess(ServletResponse response, ProjectQueryParams params, String head, Resource projectTemplate, String tail, ValueCleaner cleaner) throws IOException, SQLException {
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)projectTemplate.getInputStream(), (String)UTF8));
        try (BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            this.dao.streamProjects(this.obtainQuery(params), (OutputStream)out, head, st, tail, cleaner);
        }
    }

    @RequestMapping(value={"/noads/project2tsv.do"}, method={RequestMethod.GET})
    @Operation(summary="TSV", description="download project information in TSV format", tags={"TSV"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void processTsv(HttpServletResponse response, @RequestParam(value="funding", required=true) String funding, @RequestParam(value="article293", required=false) Boolean article293) throws Exception {
        String fundingPrefix = this.getFundingPrefix(funding, null);
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String filename = "projects_" + funding + "_" + date + ".tsv";
        response.setContentType("text/tab-separated-values");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + ".zip\"");
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));){
            this.dao.processTsvRequest(out, article293, fundingPrefix, filename);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error processing the request", e);
        }
    }

    @RequestMapping(value={"/export/streamProjectDetails.do"}, method={RequestMethod.GET})
    @Operation(summary="Stream projects", description="stream project information", tags={"Streaming"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void streamProjectDetails(HttpServletResponse response, @RequestParam(value="format", required=true) String format, @RequestParam(value="compress", required=false) Boolean compress) throws IOException, SQLException {
        if (compress != null && compress.booleanValue()) {
            response.setHeader("Content-Encoding", "gzip");
        }
        switch (format) {
            case "csv": {
                response.setContentType("text/csv");
                break;
            }
            case "json": {
                response.setContentType("text/plain");
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported format: " + format);
            }
        }
        this.dao.processProjectDetails((OutputStream)response.getOutputStream(), format, compress);
    }

    protected String obtainQuery(ProjectQueryParams params) throws IllegalArgumentException, IOException {
        String funding = params.getFundingProgramme();
        String suffix = params.getFundingPath();
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.config.getProject().getProjectsFundingQueryTemplate().getInputStream(), (String)UTF8));
        st.setAttribute("fundingprefix", (Object)this.getFundingPrefix(funding, suffix));
        String theQuery = this.setDateParameters(st.toString(), params);
        log.debug((Object)("Generated query: " + theQuery));
        return theQuery;
    }

    private String getFundingPrefix(String funding, String suffix) {
        Map fundingIds = this.dao.readFundingpathIds();
        if (!fundingIds.containsKey(funding.toUpperCase())) {
            throw new IllegalArgumentException("invalid funding " + funding);
        }
        String fundingPrefix = (String)fundingIds.get(funding.toUpperCase());
        return StringUtils.isBlank((CharSequence)suffix) ? fundingPrefix : fundingPrefix + "::" + suffix.toUpperCase();
    }

    private String setDateParameters(String query, ProjectQueryParams params) {
        String queryWithDates = query;
        if (params.getStartFrom() != null) {
            queryWithDates = queryWithDates + " AND startdate >= '" + params.getStartFrom() + "'";
        }
        if (params.getStartUntil() != null) {
            queryWithDates = queryWithDates + " AND startdate <= '" + params.getStartUntil() + "'";
        }
        if (params.getEndFrom() != null) {
            queryWithDates = queryWithDates + " AND enddate >= '" + params.getEndFrom() + "'";
        }
        if (params.getEndUntil() != null) {
            queryWithDates = queryWithDates + " AND enddate <= '" + params.getEndUntil() + "'";
        }
        return queryWithDates;
    }
}

