/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.project.domain;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Project {
    public static final String INFO_EU_REPO_GRANT_AGREEMENT = "info:eu-repo/grantAgreement/";
    private String code;
    private String acronym;
    private String title;
    private String callIdentifier;
    private String startdate;
    private String enddate;
    private boolean oaMandateForPublications;
    private boolean oaMandateForDatasets;
    private String fundingpathid;
    private String description;
    private String funder;
    private String jurisdiction;
    private String orgLegalname;
    private String orgCountry;
    private String orgRole;
    private String firstname;
    private String secondnames;
    private String email;

    public String getIdnamespace() {
        String res = INFO_EU_REPO_GRANT_AGREEMENT + this.getFunder() + "/";
        String fundingProgram = this.asFundingProgram(this.getFundingpathid());
        if (StringUtils.isNotBlank((CharSequence)fundingProgram)) {
            res = res + fundingProgram;
        }
        res = res + "/" + this.escapeCode(this.getCode());
        if (StringUtils.isNotBlank((CharSequence)this.getJurisdiction())) {
            res = res + "/" + this.getJurisdiction();
        }
        return res;
    }

    public String getListLabel() {
        return String.format("for:value:component:_%s_project_id", this.asFunder(this.getFunder()));
    }

    private String asFunder(String legalshortname) {
        switch (legalshortname.toLowerCase()) {
            case "ec": {
                return this.asFundingProgram(this.getFundingpathid()).toLowerCase();
            }
        }
        return legalshortname.toLowerCase();
    }

    public List<String> asList() {
        return Lists.newArrayList((Object[])new String[]{this.clean(this.getCode()), this.clean(this.getAcronym()), this.clean(this.getTitle()), this.clean(this.getCallIdentifier()), this.clean(this.getStartdate()), this.clean(this.getEnddate()), String.valueOf(this.isOaMandateForPublications()), String.valueOf(this.isOaMandateForDatasets()), this.clean(this.getDescription()), this.clean(this.getOrgLegalname()), this.clean(this.getOrgCountry()), this.clean(this.getOrgRole()), this.clean(this.getFirstname()), this.clean(this.getSecondnames()), this.clean(this.getEmail())});
    }

    private String clean(String s) {
        return StringUtils.isNotBlank((CharSequence)s) ? "\"" + s.replaceAll("\\n|\\t|\\s+", " ").replace("\"", "\"\"").trim() + "\"" : "";
    }

    private String escapeCode(String code) {
        return this.replaceSlash(code);
    }

    private String asFundingProgram(String fundingpathid) {
        ArrayList strings = Lists.newArrayList((Iterable)Splitter.on((String)"::").split((CharSequence)fundingpathid));
        if (strings.size() <= 1) {
            throw new IllegalStateException("Unexpected funding id: " + fundingpathid);
        }
        if (strings.size() == 2) {
            return "";
        }
        return this.replaceSlash((String)strings.get(2));
    }

    private String replaceSlash(String s) {
        return s.replaceAll("/", "%2F");
    }

    public String getCode() {
        return this.code;
    }

    public Project setCode(String code) {
        this.code = code;
        return this;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public Project setAcronym(String acronym) {
        this.acronym = acronym;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Project setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getCallIdentifier() {
        return this.callIdentifier;
    }

    public Project setCallIdentifier(String call_identifier) {
        this.callIdentifier = call_identifier;
        return this;
    }

    public String getStartdate() {
        return this.startdate;
    }

    public Project setStartdate(String startdate) {
        this.startdate = startdate;
        return this;
    }

    public String getEnddate() {
        return this.enddate;
    }

    public Project setEnddate(String enddate) {
        this.enddate = enddate;
        return this;
    }

    public boolean isOaMandateForPublications() {
        return this.oaMandateForPublications;
    }

    public Project setOaMandateForPublications(boolean oaMandateForPublications) {
        this.oaMandateForPublications = oaMandateForPublications;
        return this;
    }

    public boolean isOaMandateForDatasets() {
        return this.oaMandateForDatasets;
    }

    public Project setOaMandateForDatasets(boolean oaMandateForDatasets) {
        this.oaMandateForDatasets = oaMandateForDatasets;
        return this;
    }

    public String getFundingpathid() {
        return this.fundingpathid;
    }

    public Project setFundingpathid(String fundingpathid) {
        this.fundingpathid = fundingpathid;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Project setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public Project setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
        return this;
    }

    public String getOrgLegalname() {
        return this.orgLegalname;
    }

    public Project setOrgLegalname(String legalname) {
        this.orgLegalname = legalname;
        return this;
    }

    public String getOrgCountry() {
        return this.orgCountry;
    }

    public Project setOrgCountry(String country) {
        this.orgCountry = country;
        return this;
    }

    public String getOrgRole() {
        return this.orgRole;
    }

    public Project setOrgRole(String role) {
        this.orgRole = role;
        return this;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public Project setFirstname(String firstname) {
        this.firstname = firstname;
        return this;
    }

    public String getSecondnames() {
        return this.secondnames;
    }

    public Project setSecondnames(String secondnames) {
        this.secondnames = secondnames;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Project setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getFunder() {
        return this.funder;
    }

    public Project setFunder(String funder) {
        this.funder = funder;
        return this;
    }
}

