package eu.dnetlib.openaire.exporter.model.community;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonAutoDetect
public class CommunityWritableProperties {

	@Schema(description = "community name")
	private String name;

	@Schema(description = "community short name")
	private String shortName;

	@Schema(description = "community description")
	private String description;

	@Schema(description = "http url for the community logo")
	private String logoUrl;

	@Schema(description = "list of subjects (keywords) that characterise this community")
	private List<String> subjects;

	@Schema(description = "list of fos that characterise this community")
	private List<String> fos;

	@Schema(description = "list of sdg that characterise this community")
	private List<String> sdg;

	@Schema(description = "Advanced constraint for the association of results to the community")
	private SelectionCriteria advancedConstraint;

	@Schema(description = "status of the community, drives its visibility")
	private CommunityStatus status;

	@Schema(description = "id of the main Zenodo community")
	private String mainZenodoCommunity;

	public static CommunityWritableProperties fromDetails(final CommunityDetails details) {
		final CommunityWritableProperties p = new CommunityWritableProperties();
		p.setName(details.getName());
		p.setShortName(details.getShortName());
		p.setDescription(details.getDescription());
		p.setLogoUrl(details.getLogoUrl());
		p.setSubjects(details.getSubjects());
		p.setStatus(details.getStatus());
		p.setMainZenodoCommunity(details.getZenodoCommunity());
		p.setFos(details.getFos());
		p.setSdg(details.getSdg());
		p.setAdvancedConstraint(details.getAdvancedConstraint());
		return p;
	}

	public List<String> getFos() {
		return fos;
	}

	public void setFos(final List<String> fos) {
		this.fos = fos;
	}

	public List<String> getSdg() {
		return sdg;
	}

	public void setSdg(final List<String> sdg) {
		this.sdg = sdg;
	}

	public SelectionCriteria getAdvancedConstraint() {
		return advancedConstraint;
	}

	public void setAdvancedConstraint(final SelectionCriteria advancedConstraint) {
		this.advancedConstraint = advancedConstraint;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(final String shortName) {
		this.shortName = shortName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public String getLogoUrl() {
		return logoUrl;
	}

	public void setLogoUrl(final String logoUrl) {
		this.logoUrl = logoUrl;
	}

	public List<String> getSubjects() {
		return subjects;
	}

	public void setSubjects(final List<String> subjects) {
		this.subjects = subjects;
	}

	public CommunityStatus getStatus() {
		return status;
	}

	public void setStatus(final CommunityStatus status) {
		this.status = status;
	}

	public String getMainZenodoCommunity() {
		return mainZenodoCommunity;
	}

	public void setMainZenodoCommunity(final String mainZenodoCommunity) {
		this.mainZenodoCommunity = mainZenodoCommunity;
	}
}
