/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model.community;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;

@JsonAutoDetect
public class CommunityContentprovider {
    @Schema(description="OpenAIRE identifier for this content provider, if available", required=false)
    private String openaireId;
    @NotNull
    @Schema(description="the community identifier this content provider belongs to", required=true)
    private String communityId;
    @NotNull
    @Schema(description="identifies this content provider within the context it belongs to", required=true)
    private String id;
    @Schema(description="content provider name", required=false)
    private String name;
    @NotNull
    @Schema(description="content provider official name", required=true)
    private String officialname;
    @Schema(description="content provider selection criteria", required=false)
    private SelectionCriteria selectioncriteria;

    public String getOpenaireId() {
        return this.openaireId;
    }

    public void setOpenaireId(String openaireId) {
        this.openaireId = openaireId;
    }

    public String getCommunityId() {
        return this.communityId;
    }

    public void setCommunityId(String communityId) {
        this.communityId = communityId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOfficialname() {
        return this.officialname;
    }

    public void setOfficialname(String officialname) {
        this.officialname = officialname;
    }

    public SelectionCriteria getSelectioncriteria() {
        return this.selectioncriteria;
    }

    public void setSelectioncriteria(SelectionCriteria selectioncriteria) {
        this.selectioncriteria = selectioncriteria;
    }

    public String toString() {
        return String.format("id %s, name %s, selection criteria %s", this.id, this.name, this.toJson());
    }

    public String toJson() {
        if (this.selectioncriteria == null) {
            return "";
        }
        try {
            return new ObjectMapper().writeValueAsString((Object)this.selectioncriteria);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXML() {
        if (this.selectioncriteria == null) {
            return "";
        }
        return "<![CDATA[" + this.toJson() + "]]>";
    }
}

