package eu.dnetlib.openaire.exporter.model.community;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import eu.dnetlib.openaire.exporter.model.context.Param;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonAutoDetect
public class SubCommunity {

	@Schema(description = "the id of the subCommunity", required = true)
	private String subCommunityId;

	@Schema(description = "the community identifier this sub community belongs to", required = true)
	private String communityId;

	@Schema(description = "the parent of the subCommunity, if available (it should the id of another subCommunity)", required = false)
	private String parent;

	@Schema(description = "the label of the subCommunity", required = true)
	private String label;

	@Schema(description = "the category of the subCommunity", required = true)
	private String category;

	@Schema(description = "the parameters of the subCommunity", required = true)
	private List<Param> params = new ArrayList<>();

	@Schema(description = "it supports the claims", required = true)
	private boolean claim = false;

	@Schema(description = "it is browsable", required = true)
	private boolean browsable = false;

	public String getSubCommunityId() {
		return subCommunityId;
	}

	public void setSubCommunityId(final String subCommunityId) {
		this.subCommunityId = subCommunityId;
	}

	public String getCommunityId() {
		return communityId;
	}

	public void setCommunityId(final String communityId) {
		this.communityId = communityId;
	}

	public String getParent() {
		return parent;
	}

	public void setParent(final String parent) {
		this.parent = parent;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(final String label) {
		this.label = label;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(final String category) {
		this.category = category;
	}

	public List<Param> getParams() {
		return params;
	}

	public void setParams(final List<Param> map) {
		this.params = map;
	}

	public boolean isClaim() {
		return claim;
	}

	public void setClaim(final boolean claim) {
		this.claim = claim;
	}

	public boolean isBrowsable() {
		return browsable;
	}

	public void setBrowsable(final boolean browsable) {
		this.browsable = browsable;
	}

	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("SubCommunity [\n\tsubCommunityId = ")
			.append(subCommunityId)
			.append(",\n\tcommunityId = ")
			.append(communityId)
			.append(",\n\tparent = ")
			.append(parent)
			.append(",\n\tlabel = ")
			.append(label)
			.append(",\n\tcategory = ")
			.append(category)
			.append(",\n\tparams = ")
			.append(params)
			.append(",\n\tclaim = ")
			.append(claim)
			.append(",\n\tbrowsable = ")
			.append(browsable)
			.append("\n]");
		return builder.toString();
	}

}
