package eu.dnetlib.broker.objects.alerts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.GsonBuilder;

public class ValidatorAlertMessage implements Serializable {

	private static final long serialVersionUID = 360148412789862556L;

	private String originalId;

	private String title;

	private String datasourceId;

	private String datasourceName;

	private List<ValidatorErrorMessage> errors = new ArrayList<>();

	public String getOriginalId() {
		return originalId;
	}

	public void setOriginalId(final String originalId) {
		this.originalId = originalId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceName() {
		return datasourceName;
	}

	public void setDatasourceName(final String datasourceName) {
		this.datasourceName = datasourceName;
	}

	public List<ValidatorErrorMessage> getErrors() {
		return errors;
	}

	public void setErrors(final List<ValidatorErrorMessage> errors) {
		this.errors = errors;
	}

	public void addError(final String field, final String message) {
		errors.add(new ValidatorErrorMessage(field, message));
	}

	public static ValidatorAlertMessage fromJSON(final String json) {
		final GsonBuilder b = new GsonBuilder();
		return b.create().fromJson(json, ValidatorAlertMessage.class);
	}

}
