/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.api;

import eu.dnetlib.broker.objects.OaBrokerEventPayload;
import eu.dnetlib.broker.objects.alerts.ValidatorAlertMessage;
import eu.dnetlib.broker.objects.alerts.ValidatorErrorMessage;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ShortEventMessage
implements Serializable {
    private static final long serialVersionUID = 7302363775341307950L;
    private String eventId;
    private String originalId;
    private String title;
    private String topic;
    private float trust;
    private Map<String, String> message = new LinkedHashMap<String, String>();

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public float getTrust() {
        return this.trust;
    }

    public void setTrust(float trust) {
        this.trust = trust;
    }

    public Map<String, String> getMessage() {
        return this.message;
    }

    public void setMessage(Map<String, String> message) {
        this.message = message;
    }

    public void generateMessageFromEventPayload(OaBrokerEventPayload payload) {
        this.message = ShortEventMessage.generateMessageFromObject("", payload.getHighlight());
    }

    private static Map<String, String> generateMessageFromObject(String prefix, Object bean) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors()) {
                Object v;
                if (pd.getReadMethod() == null || (v = pd.getReadMethod().invoke(bean, new Object[0])) == null) continue;
                if (v instanceof List && !((List)v).isEmpty()) {
                    List list = (List)v;
                    for (int i = 0; i < list.size(); ++i) {
                        Object x = list.get(i);
                        if (x instanceof String && StringUtils.isNotBlank((CharSequence)x.toString())) {
                            res.put(prefix + pd.getName() + "[" + i + "]", x.toString());
                            continue;
                        }
                        res.putAll(ShortEventMessage.generateMessageFromObject(prefix + pd.getName() + "[" + i + "].", x));
                    }
                    continue;
                }
                if (v instanceof String) {
                    res.put(prefix + pd.getName(), v.toString());
                    continue;
                }
                res.putAll(ShortEventMessage.generateMessageFromObject(pd.getName() + ".", v));
            }
            return res;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public void generateMessageFromvValidatorAlertMessage(ValidatorAlertMessage payload) {
        this.message = new LinkedHashMap<String, String>();
        for (int i = 0; i < payload.getErrors().size(); ++i) {
            ValidatorErrorMessage err = payload.getErrors().get(i);
            this.message.put("Error " + i + ": " + err.getField(), err.getMessage());
        }
    }
}

