package eu.dnetlib.organizations.repository;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import eu.dnetlib.organizations.model.OrganizationSearchEntry;

@Repository
public interface OrganizationSearchEntryRepository
		extends JpaRepository<OrganizationSearchEntry, String>, JpaSpecificationExecutor<OrganizationSearchEntry> {

	// SEARCH
	@Query(value = "SELECT * FROM org_index_search idx WHERE status in :statuses AND (name_norm ilike '%'||:text||'%' OR fulltext_search(txt, :text))", nativeQuery = true)
	Page<OrganizationSearchEntry> search(@Param("text") String text, @Param("statuses") List<String> statuses, Pageable pageable);

	// SEARCH FOR USER
	@Query(value = "SELECT idx.* FROM org_index_search idx LEFT OUTER JOIN user_countries uc ON (uc.country = idx.country) WHERE uc.email = :email AND idx.status IN :statuses AND (idx.name_norm ilike '%'||:text||'%' OR fulltext_search(idx.txt, :text))", nativeQuery = true)
	Page<OrganizationSearchEntry> searchForUser(@Param("text") String text,
			@Param("email") String email,
			@Param("statuses") List<String> statuses,
			Pageable pageable);

	Page<OrganizationSearchEntry> findByCountry(String country, Pageable pageable);

	Page<OrganizationSearchEntry> findByCountryAndStatus(String code, String status, Pageable pageable);

	Page<OrganizationSearchEntry> findByType(String type, Pageable pageable);

	Page<OrganizationSearchEntry> findByTypeAndStatus(String type, String status, Pageable pageable);

	@Query(value = "SELECT idx.* FROM org_index_search idx LEFT OUTER JOIN user_countries uc ON (uc.country = idx.country) WHERE idx.type = ?1 AND uc.email = ?2", nativeQuery = true)
	Page<OrganizationSearchEntry> findByTypeForUser(String type, String email, Pageable pageable);

	@Query(value = "SELECT idx.* FROM org_index_search idx LEFT OUTER JOIN user_countries uc ON (uc.country = idx.country) WHERE idx.type = ?1 AND idx.status = ?2 AND uc.email = ?3", nativeQuery = true)
	Page<OrganizationSearchEntry> findByTypeAndStatusForUser(String type, String status, String email, Pageable pageable);

	// SEARCH FOR VALID DUPLICATE CANDIDATES
	@Query(value = "SELECT idx.* FROM org_index_search idx\n"
			+ "LEFT OUTER JOIN oa_duplicates d ON (idx.id = d.oa_original_id)\n"
			+ "WHERE idx.status = 'raw' AND (idx.name ilike '%'||:text||'%' OR fulltext_search(idx.txt, :text))"
			+ "GROUP BY idx.id\n"
			+ "HAVING  not('is_similar' = ANY(array_agg(d.status)))", nativeQuery = true)
	Page<OrganizationSearchEntry> searchCandidateDuplicates(@Param("text") String text, Pageable pageable);

	// SEARCH FOR VALID DUPLICATE CANDIDATES FOR USER
	@Query(value = "SELECT idx.* FROM org_index_search idx\n"
			+ "LEFT OUTER JOIN oa_duplicates d ON (idx.id = d.oa_original_id)\n"
			+ "LEFT OUTER JOIN user_countries uc ON (uc.country = idx.country)\n"
			+ "WHERE idx.status = 'raw' AND uc.email = :email AND (idx.name ilike '%'||:text||'%' OR fulltext_search(idx.txt, :text))\n"
			+ "GROUP BY idx.id\n"
			+ "HAVING  not('is_similar' = ANY(array_agg(d.status)))", nativeQuery = true)
	Page<OrganizationSearchEntry> searchCandidateDuplicatesForUser(@Param("text") String text, @Param("email") String email, Pageable pageable);

}
