package eu.dnetlib.organizations.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

@Entity
@Table(name = "oa_duplicates")
@IdClass(OpenaireDuplicatePK.class)
public class OpenaireDuplicate implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -5656204073481770618L;

	@Id
	@Column(name = "local_id")
	private String localId;

	@Id
	@Column(name = "oa_original_id")
	private String oaOriginalId;

	@Column(name = "status")
	private String status;

	@Column(name = "oa_collectedfrom")
	private String oaCollectedFrom;

	public OpenaireDuplicate() {}

	public OpenaireDuplicate(final String localId, final String oaOriginalId, final String status, final String oaCollectedFrom) {
		this.localId = localId;
		this.oaOriginalId = oaOriginalId;
		this.status = status;
		this.oaCollectedFrom = oaCollectedFrom;
	}

	public String getLocalId() {
		return localId;
	}

	public void setLocalId(final String localId) {
		this.localId = localId;
	}

	public String getOaOriginalId() {
		return oaOriginalId;
	}

	public void setOaOriginalId(final String oaOriginalId) {
		this.oaOriginalId = oaOriginalId;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(final String status) {
		this.status = status;
	}

	public String getOaCollectedFrom() {
		return oaCollectedFrom;
	}

	public void setOaCollectedFrom(final String oaCollectedFrom) {
		this.oaCollectedFrom = oaCollectedFrom;
	}

	@Override
	public String toString() {
		return String
				.format("OpenaireDuplicate [localId=%s, oaOriginalId=%s, status=%s, oaCollectedFrom=%s]", localId, oaOriginalId, status, oaCollectedFrom);
	}

}
