package eu.dnetlib.organizations.model;

import java.io.Serializable;
import java.util.Objects;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vladmihalcea.hibernate.type.array.StringArrayType;
import com.vladmihalcea.hibernate.type.search.PostgreSQLTSVectorType;

@Entity
@Table(name = "org_index_search")
@TypeDefs({
		@TypeDef(name = "string-array", typeClass = StringArrayType.class),
		@TypeDef(name = "tsvector", typeClass = PostgreSQLTSVectorType.class)
})
public class OrganizationSearchEntry implements Serializable, Comparable<OrganizationSearchEntry> {

	/**
	 *
	 */
	private static final long serialVersionUID = 417248897119259446L;

	@Id
	@Column(name = "id")
	private String id;

	@Column(name = "openaireId")
	private String openaireId;

	@Column(name = "name")
	private String name;

	@Column(name = "type")
	private String type;

	@Column(name = "city")
	private String city;

	@Column(name = "country")
	private String country;

	@Type(type = "string-array")
	@Column(name = "acronyms", columnDefinition = "text[]")
	private String[] acronyms;

	@JsonIgnore
	@Type(type = "string-array")
	@Column(name = "othernames", columnDefinition = "text[]")
	private String[] otherNames;

	@Type(type = "string-array")
	@Column(name = "urls", columnDefinition = "text[]")
	private String[] urls;

	@JsonIgnore
	@Type(type = "string-array")
	@Column(name = "pids", columnDefinition = "text[]")
	private String[] pids;

	@Column(name = "status")
	private String status;

	@Column(name = "n_similar_dups")
	private Long nSimilarDups;

	@Column(name = "n_suggested_dups")
	private Long nSuggestedDups;

	@Column(name = "n_different_dups")
	private Long nDifferentDups;

	@JsonIgnore
	@Column(name = "name_norm")
	private String nameNormalized;

	@JsonIgnore
	@Column(name = "type_norm")
	private String typeNormalized;

	@JsonIgnore
	@Column(name = "city_norm")
	private String cityNormalized;

	@JsonIgnore
	@Column(name = "country_norm")
	private String countryNormalized;

	@JsonIgnore
	@Column(name = "acronyms_norm")
	private String acronymsNormalized;

	@JsonIgnore
	@Column(name = "othernames_norm")
	private String otherNamesNormalized;

	@JsonIgnore
	@Column(name = "urls_norm")
	private String urlsNormalized;

	@JsonIgnore
	@Column(name = "pids_norm")
	private String pidsNormalized;

	@JsonIgnore
	@Column(name = "status_norm")
	private String statusNormalized;

	@JsonIgnore
	@Type(type = "tsvector")
	@Column(name = "txt", columnDefinition = "tsvector")
	private Object fullTextVector;

	public OrganizationSearchEntry() {}

	public OrganizationSearchEntry(final String id) {
		this.id = id;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getOpenaireId() {
		return openaireId;
	}

	public void setOpenaireId(final String openaireId) {
		this.openaireId = openaireId;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getCity() {
		return city;
	}

	public void setCity(final String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(final String country) {
		this.country = country;
	}

	public String[] getAcronyms() {
		return acronyms;
	}

	public void setAcronyms(final String[] acronyms) {
		this.acronyms = acronyms;
	}

	public String[] getOtherNames() {
		return otherNames;
	}

	public void setOtherNames(final String[] otherNames) {
		this.otherNames = otherNames;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(final String status) {
		this.status = status;
	}

	public String[] getUrls() {
		return urls;
	}

	public void setUrls(final String[] urls) {
		this.urls = urls;
	}

	public String[] getPids() {
		return pids;
	}

	public void setPids(final String[] pids) {
		this.pids = pids;
	}

	public Long getnSimilarDups() {
		return nSimilarDups;
	}

	public void setnSimilarDups(final Long nSimilarDups) {
		this.nSimilarDups = nSimilarDups;
	}

	public Long getnSuggestedDups() {
		return nSuggestedDups;
	}

	public void setnSuggestedDups(final Long nSuggestedDups) {
		this.nSuggestedDups = nSuggestedDups;
	}

	public Long getnDifferentDups() {
		return nDifferentDups;
	}

	public void setnDifferentDups(final Long nDifferentDups) {
		this.nDifferentDups = nDifferentDups;
	}

	public String getNameNormalized() {
		return nameNormalized;
	}

	public void setNameNormalized(final String nameNormalized) {
		this.nameNormalized = nameNormalized;
	}

	public String getTypeNormalized() {
		return typeNormalized;
	}

	public void setTypeNormalized(final String typeNormalized) {
		this.typeNormalized = typeNormalized;
	}

	public String getCityNormalized() {
		return cityNormalized;
	}

	public void setCityNormalized(final String cityNormalized) {
		this.cityNormalized = cityNormalized;
	}

	public String getCountryNormalized() {
		return countryNormalized;
	}

	public void setCountryNormalized(final String countryNormalized) {
		this.countryNormalized = countryNormalized;
	}

	public String getAcronymsNormalized() {
		return acronymsNormalized;
	}

	public void setAcronymsNormalized(final String acronymsNormalized) {
		this.acronymsNormalized = acronymsNormalized;
	}

	public String getOtherNamesNormalized() {
		return otherNamesNormalized;
	}

	public void setOtherNamesNormalized(final String otherNamesNormalized) {
		this.otherNamesNormalized = otherNamesNormalized;
	}

	public String getUrlsNormalized() {
		return urlsNormalized;
	}

	public void setUrlsNormalized(final String urlsNormalized) {
		this.urlsNormalized = urlsNormalized;
	}

	public String getPidsNormalized() {
		return pidsNormalized;
	}

	public void setPidsNormalized(final String pidsNormalized) {
		this.pidsNormalized = pidsNormalized;
	}

	public String getStatusNormalized() {
		return statusNormalized;
	}

	public void setStatusNormalized(final String statusNormalized) {
		this.statusNormalized = statusNormalized;
	}

	public Object getFullTextVector() {
		return fullTextVector;
	}

	public void setFullTextVector(final Object fullTextVector) {
		this.fullTextVector = fullTextVector;
	}

	@Override
	public int hashCode() {
		return Objects.hash(id);
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if (obj == null || !(obj instanceof OrganizationSearchEntry)) { return false; }
		final OrganizationSearchEntry other = (OrganizationSearchEntry) obj;
		return Objects.equals(id, other.id);
	}

	@Override
	public int compareTo(final OrganizationSearchEntry o) {
		return id.compareTo(o.getId());
	}

}
