package eu.dnetlib.organizations.model.view;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import com.vladmihalcea.hibernate.type.json.JsonStringType;

import eu.dnetlib.organizations.model.RelationshipPK;

@Entity
@Table(name = "relationship_view")
@IdClass(RelationshipPK.class)
@TypeDefs({
		@TypeDef(name = "json", typeClass = JsonStringType.class),
		@TypeDef(name = "jsonb", typeClass = JsonBinaryType.class)
})
public class RelationshipView implements Serializable {

	private static final long serialVersionUID = -8940493922287377058L;

	@Id
	@Column(name = "id1")
	private String id1;

	@Id
	@Column(name = "id2")
	private String id2;

	@Column(name = "openaire_id2")
	private String openaireId2;

	@Column(name = "reltype")
	private String relType;

	@Column(name = "status")
	private String status;

	@Column(name = "name")
	private String name;

	@Column(name = "city")
	private String city;

	@Column(name = "country")
	private String country;

	@Type(type = "jsonb")
	@Column(name = "acronyms", columnDefinition = "jsonb")
	private Set<String> acronyms;

	@Type(type = "jsonb")
	@Column(name = "urls", columnDefinition = "jsonb")
	private Set<String> urls;

	@Type(type = "jsonb")
	@Column(name = "other_ids", columnDefinition = "jsonb")
	private Set<OtherIdentifier> otherIdentifiers;

	public String getId1() {
		return id1;
	}

	public void setId1(final String id1) {
		this.id1 = id1;
	}

	public String getId2() {
		return id2;
	}

	public void setId2(final String id2) {
		this.id2 = id2;
	}

	public String getOpenaireId2() {
		return openaireId2;
	}

	public void setOpenaireId2(final String openaireId2) {
		this.openaireId2 = openaireId2;
	}

	public String getRelType() {
		return relType;
	}

	public void setRelType(final String relType) {
		this.relType = relType;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(final String status) {
		this.status = status;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getCity() {
		return city;
	}

	public void setCity(final String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(final String country) {
		this.country = country;
	}

	public Set<String> getAcronyms() {
		return acronyms;
	}

	public void setAcronyms(final Set<String> acronyms) {
		this.acronyms = acronyms;
	}

	public Set<String> getUrls() {
		return urls;
	}

	public void setUrls(final Set<String> urls) {
		this.urls = urls;
	}

	public Set<OtherIdentifier> getOtherIdentifiers() {
		return otherIdentifiers;
	}

	public void setOtherIdentifiers(final Set<OtherIdentifier> otherIdentifiers) {
		this.otherIdentifiers = otherIdentifiers;
	}

}
