package eu.dnetlib.organizations.repository;

import java.time.OffsetDateTime;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import eu.dnetlib.organizations.model.Relationship;
import eu.dnetlib.organizations.model.RelationshipPK;

public interface RelationshipRepository extends JpaRepository<Relationship, RelationshipPK> {

	List<Relationship> findById1(String id1);

	List<Relationship> findById2(String id2);

	List<Relationship> findById1OrId2(String id1, String id2);

	void deleteById1(String id1);

	void deleteById2(String id2);

	@Modifying
	@Query(value = "update relationships set created_by = ?4 where id1 = ?1 and id2 = ?2 and reltype = ?3 and (created_by is null or created_by = '')", nativeQuery = true)
	void updateCreatedByIfMissing(String id1, String id2, String relType, String user);

	@Modifying
	@Query(value = "update relationships set modified_by = ?4, modification_date = ?5 where id1 = ?1 and id2 = ?2 and reltype = ?3", nativeQuery = true)
	void updateModificationDate(String id1, String id2, String relType, String user, OffsetDateTime now);

}
