/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.organizations.controller.UserRole;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserInfo {
    private String name;
    private UserRole role;

    public UserInfo() {
        this.name = "anonymous";
        this.role = UserRole.NOT_AUTHORIZED;
    }

    public UserInfo(String name, UserRole role) {
        this.name = name;
        this.role = role;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserRole getRole() {
        return this.role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    public static UserInfo generate(Authentication authentication) {
        return new UserInfo(UserInfo.getEmail((Authentication)authentication), UserInfo.findRole((Authentication)authentication));
    }

    public static UserRole findRole(Authentication authentication) {
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(s -> StringUtils.substringAfter((String)s, (String)"ROLE_OPENORGS_")).filter(s -> EnumUtils.isValidEnum(UserRole.class, (String)s)).map(UserRole::valueOf).findFirst().orElseGet(() -> UserRole.NOT_AUTHORIZED);
    }

    public static boolean isSuperAdmin(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_OPENORGS_" + UserRole.ADMIN)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNationalAdmin(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_OPENORGS_" + UserRole.NATIONAL_ADMIN)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimpleUser(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_OPENORGS_" + UserRole.USER)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPending(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_OPENORGS_" + UserRole.PENDING)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAuthorized(Authentication authentication) {
        for (GrantedAuthority aut : authentication.getAuthorities()) {
            if (!aut.getAuthority().equals("ROLE_OPENORGS_" + UserRole.NOT_AUTHORIZED)) continue;
            return true;
        }
        return false;
    }

    public static String getEmail(Authentication authentication) {
        Object user = authentication.getPrincipal();
        return user instanceof DefaultOidcUser ? UserInfo.getEmail((OidcUser)((DefaultOidcUser)user)) : authentication.getName();
    }

    public static String getEmail(OidcUser user) {
        return user.getEmail();
    }

    public static String getFullname(Authentication authentication) {
        Object user = authentication.getPrincipal();
        return user instanceof DefaultOidcUser ? UserInfo.getFullname((OidcUser)((DefaultOidcUser)user)) : "unknown";
    }

    public static String getFullname(OidcUser user) {
        return user.getFullName();
    }

    public static String getOrganization(Authentication authentication) {
        Object user = authentication.getPrincipal();
        return user instanceof DefaultOidcUser ? UserInfo.getOrganization((OidcUser)((DefaultOidcUser)user)) : "unknown";
    }

    public static String getOrganization(OidcUser user) {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{(String)user.getAttribute("organization"), (String)user.getAttribute("affiliation")});
    }
}

