/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.utils;

import eu.dnetlib.common.exceptions.DnetException;
import eu.dnetlib.common.utils.mail.EmailFactory;
import eu.dnetlib.common.utils.mail.EmailMessage;
import eu.dnetlib.organizations.controller.UserRole;
import eu.dnetlib.organizations.model.SystemConfiguration;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.SystemConfigurationRepository;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MailDispatcher {
    @Autowired
    private SystemConfigurationRepository systemConfigurationRepository;
    private final EmailFactory emailFactory = new EmailFactory();
    private boolean enabled = true;
    private String fromMail;
    private String fromName;
    private String toMailAdmin;
    private String newUserMessage;
    private String updateUserMessage;
    private static final Log log = LogFactory.getLog(MailDispatcher.class);

    @PostConstruct
    public void configure() {
        SystemConfiguration conf = (SystemConfiguration)this.systemConfigurationRepository.findById((Object)"default").get();
        this.configure(conf);
    }

    public void configure(SystemConfiguration conf) {
        this.enabled = conf.getSmtpEnabled();
        this.fromMail = conf.getSmtpFromMail();
        this.fromName = conf.getSmtpFromName();
        this.toMailAdmin = conf.getSmtpToMailAdmin();
        this.newUserMessage = conf.getSmtpNewUserMessage();
        this.updateUserMessage = conf.getSmtpUpdateUserMessage();
        if (StringUtils.isNotBlank((CharSequence)conf.getSmtpHost())) {
            this.emailFactory.setSmtpHost(conf.getSmtpHost());
        } else {
            this.emailFactory.setSmtpHost("localhost");
        }
        if (conf.getSmtpPort() != null) {
            this.emailFactory.setSmtpPort(conf.getSmtpPort().intValue());
        } else {
            this.emailFactory.setSmtpPort(587);
        }
        if (StringUtils.isNotBlank((CharSequence)conf.getSmtpUser())) {
            this.emailFactory.setSmtpUser(conf.getSmtpUser());
            this.emailFactory.setSmtpPassword(conf.getSmtpPassword());
        } else {
            this.emailFactory.setSmtpUser(null);
            this.emailFactory.setSmtpPassword(null);
        }
    }

    public void sendRequestRegistrationMail(UserView user) {
        if (StringUtils.isNotBlank((CharSequence)this.newUserMessage)) {
            String message = this.prepareMessage(this.newUserMessage, user);
            for (String to : StringUtils.split((String)this.toMailAdmin, (String)",")) {
                this.sendMail("OpenOrgs: new registration request", message, to.trim());
            }
        } else {
            log.warn((Object)"Template is empty (newUserMessage)");
        }
    }

    public void sendUpdatedUserMail(UserView user) {
        if (StringUtils.isNotBlank((CharSequence)this.updateUserMessage)) {
            String message = this.prepareMessage(this.updateUserMessage, user);
            this.sendMail("OpenOrgs: user updated", message, user.getEmail());
        } else {
            log.warn((Object)"Template is empty (updateUserMessage)");
        }
    }

    private String prepareMessage(String template, UserView user) {
        String countries = user.getRole().equals(UserRole.ADMIN.toString()) ? "All" : StringUtils.join((Object[])user.getCountries(), (String)", ");
        return template.replaceAll(":email:", "" + user.getEmail()).replaceAll(":fullname:", "" + user.getFullname()).replaceAll(":organization:", "" + user.getOrganization()).replaceAll(":refperson:", "" + user.getReferencePerson()).replaceAll(":reqmessage:", "" + user.getRequestMessage()).replaceAll(":role:", "" + user.getRole()).replaceAll(":countries:", countries);
    }

    private void sendMail(String subject, String content, String to) {
        if (!this.enabled) {
            log.debug((Object)"Mail not sent: MailDispatcher is disabled");
        } else if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{subject, content, to, this.fromMail, this.fromName})) {
            log.warn((Object)"Mail not sent: some fields are empty");
            log.warn((Object)("  - subject: " + subject));
            log.warn((Object)("  - to: " + to));
            log.warn((Object)("  - fromMail: " + this.fromMail));
            log.warn((Object)("  - fromName: " + this.fromName));
            log.warn((Object)("  - content: " + content));
        } else {
            try {
                EmailMessage mail = this.emailFactory.prepareEmail(subject, content, this.fromMail, this.fromName, to, new String[0]);
                mail.sendMail();
            }
            catch (DnetException e) {
                log.error((Object)"Error sending mail", (Throwable)e);
            }
        }
    }
}

