/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp;

import eu.dnetlib.dhp.solr.RecordImporter;
import eu.dnetlib.dhp.utils.ArgumentApplicationParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordImporterApplication {
    private static final Logger log = LoggerFactory.getLogger(RecordImporterApplication.class);
    private static final String APPLICATION_JAR = "./openaire-solr-record-importer.jar";
    private static final String APPLICATION_TITLE = "OpenAIRE Solr record importer";
    private static final String DEFAULT_TASKS = "*";

    public static void main(String[] args) throws IOException, ParseException {
        ArgumentApplicationParser cmd = RecordImporterApplication.parseArguments(args);
        for (String s : args) {
            if (!s.equals("-h") && !s.equals("--help")) continue;
            RecordImporterApplication.printHelpAndExit(cmd.getOptions());
        }
        log.info("**** EXECUTING - {} ***", (Object)APPLICATION_TITLE);
        Boolean isSparkSessionManaged = Optional.ofNullable(cmd.getOptionValue("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String path = cmd.getOptionValue("path");
        log.info("path: {}", (Object)path);
        String collection = cmd.getOptionValue("collection");
        log.info("collection: {}", (Object)collection);
        String zkHost = cmd.getOptionValue("zkHost");
        log.info("zkHost: {}", (Object)zkHost);
        String tasks = Optional.ofNullable(cmd.getOptionValue("tasks")).orElse(DEFAULT_TASKS);
        log.info("tasks: {}", (Object)tasks);
        int batchSize = Optional.ofNullable(cmd.getOptionValue("batchSize")).map(Integer::parseInt).orElse(1000);
        log.info("batchSize: {}", (Object)tasks);
        Boolean shouldCommit = Optional.ofNullable(cmd.getOptionValue("shouldCommit")).map(Boolean::valueOf).orElse(Boolean.FALSE);
        log.info("shouldCommit: {}", (Object)shouldCommit);
        SparkConf conf = new SparkConf();
        if (Boolean.FALSE.equals(isSparkSessionManaged)) {
            conf.setAppName(APPLICATION_TITLE);
            conf.setMaster(String.format("local[%s]", tasks));
            conf.set("spark.driver.host", "localhost");
            conf.set("spark.ui.enabled", "false");
        }
        RecordImporter.importRecords(conf, zkHost, collection, path, batchSize, shouldCommit);
        log.info("**** DONE ***");
    }

    private static ArgumentApplicationParser parseArguments(String[] args) throws IOException, ParseException {
        return ArgumentApplicationParser.parse(IOUtils.toString((InputStream)Objects.requireNonNull(RecordImporterApplication.class.getResourceAsStream("/eu/dnetlib/dhp/input_parameters.json")), (Charset)Charset.defaultCharset()), args);
    }

    private static void printHelpAndExit(Options options) {
        String ln = StringUtils.repeat((String)"=", (int)APPLICATION_TITLE.length());
        System.out.println(String.format("\n%s\n%s\n%s\n", ln, APPLICATION_TITLE, ln));
        new HelpFormatter().printHelp(APPLICATION_JAR, options, true);
        System.exit(1);
    }
}

