package eu.dnetlib.dhp.solr;

import java.io.Serializable;
import java.util.Objects;

public class CloudClientParams implements Serializable {

    private static int ZKCLIENTTIMEOUT = 30000;
    private static int ZKCONNECTTIMEOUT = 60000;

    private String zkHost;
    private String collection;
    private int zkClientTimeout = 30000;
    private int zkConnectTimeout = 60000;

    public CloudClientParams(String zkHost, String collection, int zkClientTimeout, int zkConnectTimeout) {
        this.zkHost = zkHost;
        this.collection = collection;
        this.zkClientTimeout = zkClientTimeout;
        this.zkConnectTimeout = zkConnectTimeout;
    }

    public CloudClientParams(String zkHost, String collection) {
        this(zkHost, collection, ZKCLIENTTIMEOUT, ZKCONNECTTIMEOUT);
    }

    public String getZkHost() {
        return zkHost;
    }

    public String getCollection() {
        return collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public int getZkClientTimeout() {
        return zkClientTimeout;
    }

    public int getZkConnectTimeout() {
        return zkConnectTimeout;
    }

    @Override
    public int hashCode() {
        return Objects.hash(getZkHost(), getCollection(), getZkClientTimeout(), getZkConnectTimeout());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        final CloudClientParams other = (CloudClientParams) obj;
        return Objects.equals(this.zkHost, other.zkHost)
                && Objects.equals(this.collection, other.collection)
                && Objects.equals(this.zkClientTimeout, other.zkClientTimeout)
                && Objects.equals(this.zkConnectTimeout, other.zkConnectTimeout);
    }
}
