/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.solr;

import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import eu.dnetlib.dhp.solr.CloudClientParams;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCloudSolrClient
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CacheCloudSolrClient.class);
    private static final CacheLoader<CloudClientParams, CloudSolrClient> loader = new CacheLoader<CloudClientParams, CloudSolrClient>(){

        public CloudSolrClient load(CloudClientParams params) throws Exception {
            return CacheCloudSolrClient.getCloudSolrClient(params);
        }
    };
    private static final RemovalListener<CloudClientParams, CloudSolrClient> listener = rn -> Optional.ofNullable((CloudSolrClient)rn.getValue()).ifPresent(client -> {
        try {
            client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private static final LoadingCache<CloudClientParams, CloudSolrClient> cache = CacheBuilder.newBuilder().removalListener(listener).build(loader);

    public static void invalidateCachedClient(CloudClientParams params) {
        cache.invalidate((Object)params);
    }

    public static CloudSolrClient getCachedCloudClient(CloudClientParams params) throws ExecutionException {
        return (CloudSolrClient)cache.get((Object)params);
    }

    private static CloudSolrClient getCloudSolrClient(CloudClientParams cloudClientParams) {
        String zkHost = cloudClientParams.getZkHost();
        log.info("Creating a new SolrCloudClient for zkhost {}", (Object)zkHost);
        List zkUrlList = StreamSupport.stream(Splitter.on((String)",").split((CharSequence)zkHost).spliterator(), false).collect(Collectors.toList());
        CloudSolrClient.Builder solrClientBuilder = new CloudSolrClient.Builder(zkUrlList, Optional.empty());
        CloudSolrClient solrClient = solrClientBuilder.build();
        solrClient.connect();
        log.debug("Created new SolrCloudClient for zkhost {}", (Object)zkHost);
        return solrClient;
    }
}

