package eu.dnetlib.dhp.solr;

import java.io.Serializable;
import java.util.Objects;

public class CloudClientParams implements Serializable {

    public static final int DEFAULT_ZKCLIENTTIMEOUT = 30000;
    public static final int DEFAULT_ZKCONNECTTIMEOUT = 60000;

    public static final int DEFAULT_HTTPCONNECTIMEOUT_MS = 30000;
    public static final int DEFAULT_HTTPSOCKETTIMEOUT_MS = 60000;

    public static final int DEFAULT_HTTP_MAX_CONNECTIONS_TOTAL = 200;
    public static final int DEFAULT_HTTP_MAX_CONNECTIONS_PER_ROUTE = 64;


    private final String zkHost;
    private final String collection;
    private final int zkClientTimeout;
    private final int zkConnectTimeout;

    private final int httpConnectTimeoutMillis;
    private final int httpSocketTimeoutMillis;

    private final int maxConnTotal;
    private final int maxConnPerRoute;

    public CloudClientParams(String zkHost, String collection, int zkClientTimeout, int zkConnectTimeout, int httpConnectTimeoutMillis, int httpSocketTimeoutMillis, int maxConnTotal, int maxConnPerRoute) {
        this.zkHost = zkHost;
        this.collection = collection;
        this.zkClientTimeout = zkClientTimeout;
        this.zkConnectTimeout = zkConnectTimeout;
        this.httpConnectTimeoutMillis = httpConnectTimeoutMillis;
        this.httpSocketTimeoutMillis = httpSocketTimeoutMillis;
        this.maxConnTotal = maxConnTotal;
        this.maxConnPerRoute = maxConnPerRoute;
    }

    public CloudClientParams(String zkHost, String collection, int zkClientTimeout, int zkConnectTimeout) {
        this(zkHost, collection, zkClientTimeout, zkConnectTimeout, DEFAULT_HTTPCONNECTIMEOUT_MS, DEFAULT_HTTPSOCKETTIMEOUT_MS, DEFAULT_HTTP_MAX_CONNECTIONS_TOTAL, DEFAULT_HTTP_MAX_CONNECTIONS_PER_ROUTE);
    }

    public CloudClientParams(String zkHost, String collection, int httpConnectTimeoutMillis, int httpSocketTimeoutMillis, int maxConnTotal, int maxConnPerRoute) {
        this(zkHost, collection, DEFAULT_ZKCLIENTTIMEOUT, DEFAULT_ZKCONNECTTIMEOUT, httpConnectTimeoutMillis, httpSocketTimeoutMillis, maxConnTotal, maxConnPerRoute);
    }

    public CloudClientParams(String zkHost, String collection) {
        this(zkHost, collection, DEFAULT_ZKCLIENTTIMEOUT, DEFAULT_ZKCONNECTTIMEOUT);
    }

    public String getZkHost() {
        return zkHost;
    }

    public String getCollection() {
        return collection;
    }

    public int getZkClientTimeout() {
        return zkClientTimeout;
    }

    public int getZkConnectTimeout() {
        return zkConnectTimeout;
    }

    public int getHttpConnectTimeoutMillis() {
        return httpConnectTimeoutMillis;
    }

    public int getHttpSocketTimeoutMillis() {
        return httpSocketTimeoutMillis;
    }

    public int getMaxConnTotal() {
        return maxConnTotal;
    }

    public int getMaxConnPerRoute() {
        return maxConnPerRoute;
    }

    @Override
    public int hashCode() {
        return Objects.hash(getZkHost(), getCollection(), getZkClientTimeout(), getZkConnectTimeout());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        final CloudClientParams other = (CloudClientParams) obj;
        return Objects.equals(this.zkHost, other.zkHost)
                && Objects.equals(this.collection, other.collection)
                && Objects.equals(this.zkClientTimeout, other.zkClientTimeout)
                && Objects.equals(this.zkConnectTimeout, other.zkConnectTimeout);
    }
}
