/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp;

import eu.dnetlib.dhp.solr.CloudClientParams;
import eu.dnetlib.dhp.solr.RecordImporter;
import eu.dnetlib.dhp.utils.ArgumentApplicationParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordImporterApplication {
    private static final Logger log = LoggerFactory.getLogger(RecordImporterApplication.class);
    private static final String APPLICATION_JAR = "./openaire-solr-record-importer.jar";
    private static final String APPLICATION_TITLE = "OpenAIRE Solr record importer";
    private static final String DEFAULT_TASKS = "*";

    public static void main(String[] args) throws IOException, ParseException {
        ArgumentApplicationParser cmd = RecordImporterApplication.parseArguments(args);
        for (String s : args) {
            if (!s.equals("-h") && !s.equals("--help")) continue;
            RecordImporterApplication.printHelpAndExit(cmd.getOptions());
        }
        log.info("**** EXECUTING - {} ***", (Object)APPLICATION_TITLE);
        Boolean isSparkSessionManaged = Optional.ofNullable(cmd.getOptionValue("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String path = cmd.getOptionValue("path");
        log.info("path: {}", (Object)path);
        String collection = cmd.getOptionValue("collection");
        log.info("collection: {}", (Object)collection);
        String zkHost = cmd.getOptionValue("zkHost");
        log.info("zkHost: {}", (Object)zkHost);
        int zkClientTimeout = Optional.ofNullable(cmd.getOptionValue("zkClientTimeout")).map(Integer::valueOf).orElse(30000);
        log.info("zkClientTimeout: {}", (Object)zkClientTimeout);
        int zkConnectTimeout = Optional.ofNullable(cmd.getOptionValue("zkConnectTimeout")).map(Integer::valueOf).orElse(60000);
        log.info("zkConnectTimeout: {}", (Object)zkConnectTimeout);
        int httpConnectTimeoutMillis = Optional.ofNullable(cmd.getOptionValue("httpConnectTimeoutMillis")).map(Integer::valueOf).orElse(30000);
        log.info("httpConnectTimeoutMillis: {}", (Object)httpConnectTimeoutMillis);
        int httpSocketTimeoutMillis = Optional.ofNullable(cmd.getOptionValue("httpSocketTimeoutMillis")).map(Integer::valueOf).orElse(60000);
        log.info("httpSocketTimeoutMillis: {}", (Object)httpSocketTimeoutMillis);
        int maxConnTotal = Optional.ofNullable(cmd.getOptionValue("maxConnTotal")).map(Integer::valueOf).orElse(200);
        log.info("maxConnTotal: {}", (Object)maxConnTotal);
        int maxConnPerRoute = Optional.ofNullable(cmd.getOptionValue("maxConnPerRoute")).map(Integer::valueOf).orElse(64);
        log.info("maxConnPerRoute: {}", (Object)maxConnPerRoute);
        String tasks = Optional.ofNullable(cmd.getOptionValue("tasks")).orElse(DEFAULT_TASKS);
        log.info("tasks: {}", (Object)tasks);
        int batchSize = Optional.ofNullable(cmd.getOptionValue("batchSize")).map(Integer::parseInt).orElse(1000);
        log.info("batchSize: {}", (Object)tasks);
        Boolean shouldCommit = Optional.ofNullable(cmd.getOptionValue("shouldCommit")).map(Boolean::valueOf).orElse(Boolean.FALSE);
        log.info("shouldCommit: {}", (Object)shouldCommit);
        Boolean shouldFilterXmlPayload = Optional.ofNullable(cmd.getOptionValue("shouldFilterXmlPayload")).map(Boolean::valueOf).orElse(Boolean.FALSE);
        log.info("shouldFilterXmlPayload: {}", (Object)shouldFilterXmlPayload);
        SparkConf conf = new SparkConf();
        if (Boolean.FALSE.equals(isSparkSessionManaged)) {
            conf.setAppName(APPLICATION_TITLE);
            conf.setMaster(String.format("local[%s]", tasks));
            conf.set("spark.driver.host", "localhost");
            conf.set("spark.ui.enabled", "false");
        }
        CloudClientParams params = new CloudClientParams(zkHost, collection, zkClientTimeout, zkConnectTimeout, httpConnectTimeoutMillis, httpSocketTimeoutMillis, maxConnTotal, maxConnPerRoute);
        RecordImporter.importRecords(conf, params, path, batchSize, shouldCommit, shouldFilterXmlPayload);
        log.info("**** DONE ***");
    }

    private static ArgumentApplicationParser parseArguments(String[] args) throws IOException, ParseException {
        return ArgumentApplicationParser.parse(IOUtils.toString((InputStream)Objects.requireNonNull(RecordImporterApplication.class.getResourceAsStream("/eu/dnetlib/dhp/input_parameters.json")), (Charset)Charset.defaultCharset()), args);
    }

    private static void printHelpAndExit(Options options) {
        String ln = StringUtils.repeat((String)"=", (int)APPLICATION_TITLE.length());
        System.out.println(String.format("\n%s\n%s\n%s\n", ln, APPLICATION_TITLE, ln));
        new HelpFormatter().printHelp(APPLICATION_JAR, options, true);
        System.exit(1);
    }
}

