/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.solr.mapping;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;

public class MappingUtils
implements Serializable {
    public static final String BLANK = "";
    public static final String INFO_EU_REPO_DATE_PUBLICATION = "info:eu-repo/date/publication/";
    private static final String NORMALIZE_OUT_FORMAT = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    private static final String[] NORMALIZE_INPUT_FORMATS = new String[]{"yyyy-MM-dd'T'hh:mm:ss'Z'", "yyyy-MM-dd'T'hh:mm:ss", "yyyy/MM/dd", "yyyy-MM-dd", "yyyy"};
    private static final String[] dateFormats = new String[]{"yyyy-MM-dd'T'hh:mm:ss'Z'", "yyyy/MM/dd"};

    public static String extractYear(String s) {
        GregorianCalendar c = new GregorianCalendar();
        for (String format : dateFormats) {
            try {
                c.setTime(new SimpleDateFormat(format).parse(s));
                return String.valueOf(c.get(1));
            }
            catch (ParseException parseException) {
            }
        }
        return BLANK;
    }

    public static String normalizeDate(String s) {
        String date = StringUtils.isNotBlank((CharSequence)s) ? s.replace(INFO_EU_REPO_DATE_PUBLICATION, BLANK).trim() : BLANK;
        for (String format : NORMALIZE_INPUT_FORMATS) {
            try {
                Date parse = new SimpleDateFormat(format).parse(date);
                return new SimpleDateFormat(NORMALIZE_OUT_FORMAT).format(parse);
            }
            catch (ParseException parseException) {
            }
        }
        return BLANK;
    }

    public static void addField(String fieldName, Optional<String> value, SolrInputDocument doc) {
        value.ifPresent(val -> MappingUtils.addField(fieldName, Collections.singletonList(val), new ArrayList<String>(), doc));
    }

    public static void addField(String fieldName, String value, SolrInputDocument doc) {
        MappingUtils.addField(fieldName, Collections.singletonList(value), new ArrayList<String>(), doc);
    }

    public static void addField(String fieldName, List<String> value, SolrInputDocument doc) {
        Optional.ofNullable(value).ifPresent(val -> MappingUtils.addField(fieldName, val, new ArrayList<String>(), doc));
    }

    public static void addField(String fieldName, String value, List<String> otherVals, SolrInputDocument doc) {
        MappingUtils.addField(fieldName, Collections.singletonList(value), otherVals, doc);
    }

    public static void addField(String fieldName, List<String> value, List<String> otherVals, SolrInputDocument doc) {
        Set values = Stream.concat(((List)Optional.ofNullable(value).orElse(new ArrayList())).stream(), ((List)Optional.ofNullable(otherVals).orElse(new ArrayList())).stream()).collect(Collectors.toCollection(HashSet::new));
        if (!values.isEmpty()) {
            doc.addField(fieldName, (Object)values);
        }
    }
}

