/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.solr.mapping;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.solr.Author;
import eu.dnetlib.dhp.schema.solr.BestAccessRight;
import eu.dnetlib.dhp.schema.solr.Category;
import eu.dnetlib.dhp.schema.solr.CodeLabel;
import eu.dnetlib.dhp.schema.solr.Concept;
import eu.dnetlib.dhp.schema.solr.Context;
import eu.dnetlib.dhp.schema.solr.Country;
import eu.dnetlib.dhp.schema.solr.Datasource;
import eu.dnetlib.dhp.schema.solr.EoscIfGuidelines;
import eu.dnetlib.dhp.schema.solr.ExternalReference;
import eu.dnetlib.dhp.schema.solr.Funder;
import eu.dnetlib.dhp.schema.solr.Funding;
import eu.dnetlib.dhp.schema.solr.FundingLevel;
import eu.dnetlib.dhp.schema.solr.Language;
import eu.dnetlib.dhp.schema.solr.Organization;
import eu.dnetlib.dhp.schema.solr.Pid;
import eu.dnetlib.dhp.schema.solr.Project;
import eu.dnetlib.dhp.schema.solr.Provenance;
import eu.dnetlib.dhp.schema.solr.RecordType;
import eu.dnetlib.dhp.schema.solr.RelatedRecord;
import eu.dnetlib.dhp.schema.solr.RelatedRecordHeader;
import eu.dnetlib.dhp.schema.solr.Result;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.dhp.schema.solr.Subject;
import eu.dnetlib.dhp.solr.mapping.MappingUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;

public class SolrInputDocumentMapper
implements Serializable {
    private static final String INDEX_JSON_RESULT = "__json";
    private static final String INDEX_RESULT = "__result";
    private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    private static final String DELIMITER = "||";

    public static SolrInputDocument map(SolrRecord sr, String xml, boolean shouldFilterXmlPayload) throws JsonProcessingException {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)xml) && !SolrInputDocumentMapper.filterXmlPayload(sr, shouldFilterXmlPayload)) {
            doc.addField(INDEX_RESULT, (Object)xml);
        }
        if (Objects.isNull(sr)) {
            throw new IllegalArgumentException("SolrRecord cannot be null");
        }
        doc.addField(INDEX_JSON_RESULT, (Object)mapper.writeValueAsString((Object)sr));
        doc.addField("__indexrecordidentifier", (Object)sr.getHeader().getId());
        SolrInputDocumentMapper.mapCommonFields(doc, sr);
        SolrInputDocumentMapper.addRelatedRecordFields(doc, Optional.ofNullable(sr.getLinks()).orElse(new ArrayList()));
        switch (sr.getHeader().getRecordType()) {
            case publication: 
            case dataset: 
            case software: 
            case other: {
                SolrInputDocumentMapper.mapResultFields(doc, sr.getResult(), sr.getLinks());
                break;
            }
            case datasource: {
                SolrInputDocumentMapper.mapDatasourceFields(doc, sr.getDatasource());
                break;
            }
            case organization: {
                SolrInputDocumentMapper.mapOrganizationFields(doc, sr.getOrganization(), SolrInputDocumentMapper.filterLinks(sr.getLinks(), "merges"));
                break;
            }
            case project: {
                SolrInputDocumentMapper.mapProjectFields(doc, sr.getProject());
                break;
            }
            case person: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + sr.getHeader().getRecordType());
            }
        }
        return doc;
    }

    private static boolean filterXmlPayload(SolrRecord sr, Boolean shouldFilterXmlPayload) {
        if (Boolean.TRUE.equals(shouldFilterXmlPayload)) {
            boolean isProject = RecordType.project.equals((Object)sr.getHeader().getRecordType());
            boolean isRelatedToEcFunding = Optional.ofNullable(sr.getLinks()).map(links -> links.stream().anyMatch(rr -> {
                boolean isRelatedProject = RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType());
                String funderShortName = Optional.ofNullable(rr.getFunding()).map(Funding::getFunder).map(Funder::getShortname).orElse("");
                return isRelatedProject && "EC".equals(funderShortName);
            })).orElse(false);
            return !isProject && !isRelatedToEcFunding;
        }
        return false;
    }

    private static void mapCommonFields(SolrInputDocument doc, SolrRecord sr) {
        doc.addField("objidentifier", (Object)sr.getHeader().getId());
        doc.addField("oaftype", (Object)SolrInputDocumentMapper.mapToOafType(sr.getHeader().getRecordType()));
        MappingUtils.addField("collectedfromname", Optional.ofNullable(sr.getCollectedfrom()).map(c -> c.stream().map(Provenance::getDsName).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("collectedfromdatasourceid", Optional.ofNullable(sr.getCollectedfrom()).stream().flatMap(Collection::stream).map(Provenance::getDsId).toList(), doc);
        MappingUtils.addField("influence", SolrInputDocumentMapper.getMeasure(sr, "influence", "score"), doc);
        MappingUtils.addField("influence_class", SolrInputDocumentMapper.getMeasure(sr, "influence", "class"), doc);
        MappingUtils.addField("popularity", SolrInputDocumentMapper.getMeasure(sr, "popularity", "score"), doc);
        MappingUtils.addField("popularity_class", SolrInputDocumentMapper.getMeasure(sr, "popularity", "class"), doc);
        MappingUtils.addField("citation_count", SolrInputDocumentMapper.getMeasure(sr, "influence_alt", "score"), doc);
        MappingUtils.addField("citation_count_class", SolrInputDocumentMapper.getMeasure(sr, "influence_alt", "class"), doc);
        MappingUtils.addField("popularity_alt", SolrInputDocumentMapper.getMeasure(sr, "popularity_alt", "score"), doc);
        MappingUtils.addField("popularity_alt_class", SolrInputDocumentMapper.getMeasure(sr, "popularity_alt", "class"), doc);
        MappingUtils.addField("impulse", SolrInputDocumentMapper.getMeasure(sr, "impulse", "score"), doc);
        MappingUtils.addField("impulse_class", SolrInputDocumentMapper.getMeasure(sr, "impulse", "class"), doc);
        MappingUtils.addField("status", Optional.ofNullable(sr.getHeader().getStatus()).map(Enum::toString), doc);
        MappingUtils.addField("originalid", sr.getHeader().getOriginalId(), doc);
        MappingUtils.addField("pid", Optional.ofNullable(sr.getPid()).stream().flatMap(p -> p.stream().map(Pid::getValue)).toList(), doc);
        MappingUtils.addField("pidclassid", Optional.ofNullable(sr.getPid()).stream().flatMap(p -> p.stream().map(Pid::getTypeCode)).toList(), doc);
        MappingUtils.addField("deletedbyinference", sr.getHeader().getDeletedbyinference().toString(), doc);
        MappingUtils.addField("contextid", Optional.ofNullable(sr.getContext()).stream().flatMap(Collection::stream).map(Context::getId).toList(), doc);
        MappingUtils.addField("contextname", Optional.ofNullable(sr.getContext()).stream().flatMap(Collection::stream).map(Context::getLabel).toList(), doc);
        MappingUtils.addField("community", Optional.ofNullable(sr.getContext()).stream().flatMap(Collection::stream).filter(c -> "community".equals(c.getType()) || "ri".equals(c.getType())).map(c -> new StringJoiner(DELIMITER).add(c.getId()).add(c.getLabel()).toString()).toList(), doc);
        MappingUtils.addField("communityid", Optional.ofNullable(sr.getContext()).stream().flatMap(Collection::stream).filter(c -> "community".equals(c.getType()) || "ri".equals(c.getType())).map(Context::getId).toList(), doc);
        MappingUtils.addField("categoryid", Optional.ofNullable(sr.getContext()).stream().flatMap(Collection::stream).flatMap(c -> Optional.ofNullable(c.getCategory()).stream().flatMap(Collection::stream).map(Category::getId)).toList(), doc);
        MappingUtils.addField("conceptname", Optional.ofNullable(sr.getContext()).stream().flatMap(Collection::stream).flatMap(c -> Optional.ofNullable(c.getCategory()).stream().flatMap(Collection::stream).flatMap(ca -> Optional.ofNullable(ca.getConcept()).stream().flatMap(Collection::stream).map(Concept::getLabel))).toList(), doc);
    }

    private static Optional<String> getMeasure(SolrRecord sr, String id, String unitCode) {
        return Optional.ofNullable(sr.getMeasures()).stream().flatMap(measures -> measures.stream().filter(m -> id.equals(m.getId())).flatMap(m -> m.getUnit().stream()).filter(u -> unitCode.equals(u.getCode())).map(CodeLabel::getLabel)).findFirst();
    }

    private static void addRelatedRecordFields(SolrInputDocument doc, List<RelatedRecord> links) {
        MappingUtils.addField("reldatasourcecompatibilityid", links.stream().filter(rr -> RecordType.datasource.equals((Object)rr.getHeader().getRelatedRecordType())).map(RelatedRecord::getOpenairecompatibility).map(CodeLabel::getCode).toList(), doc);
        MappingUtils.addField("relproject", links.stream().filter(rr -> RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType())).map(rr -> {
            String projectName = (String)ObjectUtils.firstNonNull((Object[])new String[]{rr.getAcronym(), rr.getProjectTitle()});
            if (StringUtils.isNotBlank((CharSequence)projectName)) {
                return new StringJoiner(DELIMITER).add(rr.getHeader().getRelatedIdentifier()).add(projectName).toString();
            }
            return null;
        }).filter(Objects::nonNull).toList(), doc);
        MappingUtils.addField("relprojectid", links.stream().map(RelatedRecord::getHeader).filter(header -> RecordType.project.equals((Object)header.getRelatedRecordType())).map(RelatedRecordHeader::getRelatedIdentifier).toList(), doc);
        MappingUtils.addField("relprojectcode", links.stream().filter(rr -> RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType())).map(RelatedRecord::getCode).toList(), doc);
        MappingUtils.addField("relprojectname", links.stream().filter(rr -> RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType())).map(RelatedRecord::getAcronym).toList(), doc);
        MappingUtils.addField("relprojecttitle", links.stream().filter(rr -> RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType())).map(RelatedRecord::getProjectTitle).toList(), doc);
        MappingUtils.addField("relcontracttypename", links.stream().filter(rr -> RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType())).flatMap(rr -> Optional.ofNullable(rr.getContracttype()).map(CodeLabel::getLabel).stream()).toList(), doc);
        MappingUtils.addField("relorganizationcountryid", links.stream().filter(rr -> RecordType.organization.equals((Object)rr.getHeader().getRelatedRecordType())).flatMap(rr -> Optional.ofNullable(rr.getCountry()).map(Country::getCode).stream()).toList(), doc);
        MappingUtils.addField("relorganizationcountryname", links.stream().filter(rr -> RecordType.organization.equals((Object)rr.getHeader().getRelatedRecordType())).flatMap(rr -> Optional.ofNullable(rr.getCountry()).map(Country::getLabel).stream()).toList(), doc);
        MappingUtils.addField("relorganizationid", links.stream().map(RelatedRecord::getHeader).filter(header -> RecordType.organization.equals((Object)header.getRelatedRecordType())).map(RelatedRecordHeader::getRelatedIdentifier).toList(), doc);
        MappingUtils.addField("relorganizationname", links.stream().filter(rr -> RecordType.organization.equals((Object)rr.getHeader().getRelatedRecordType())).map(RelatedRecord::getLegalname).toList(), doc);
        MappingUtils.addField("relorganizationshortname", links.stream().filter(rr -> RecordType.organization.equals((Object)rr.getHeader().getRelatedRecordType())).map(RelatedRecord::getLegalshortname).toList(), doc);
        MappingUtils.addField("relorganization", links.stream().filter(rr -> RecordType.organization.equals((Object)rr.getHeader().getRelatedRecordType())).map(rr -> Stream.of(rr.getHeader().getRelatedIdentifier(), rr.getLegalname()).filter(StringUtils::isNotBlank).collect(Collectors.joining(DELIMITER))).toList(), doc);
        MappingUtils.addField("relresultid", links.stream().map(RelatedRecord::getHeader).filter(rh -> "result".equals(SolrInputDocumentMapper.mapToOafType(rh.getRelatedRecordType()))).map(RelatedRecordHeader::getRelatedIdentifier).toList(), doc);
        MappingUtils.addField("relresulttype", links.stream().map(RelatedRecord::getHeader).map(RelatedRecordHeader::getRelatedRecordType).map(Enum::toString).toList(), doc);
        MappingUtils.addField("relclass", links.stream().map(RelatedRecord::getHeader).map(RelatedRecordHeader::getRelationClass).toList(), doc);
        List<Funding> fundingStream = links.stream().filter(rr -> RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType())).map(RelatedRecord::getFunding).filter(Objects::nonNull).toList();
        MappingUtils.addField("relfundinglevel0_id", fundingStream.stream().map(Funding::getLevel0).filter(Objects::nonNull).map(FundingLevel::getId).toList(), doc);
        MappingUtils.addField("relfundinglevel0_name", fundingStream.stream().map(Funding::getLevel0).filter(Objects::nonNull).map(FundingLevel::getName).toList(), doc);
        MappingUtils.addField("relfundinglevel1_id", fundingStream.stream().map(Funding::getLevel1).filter(Objects::nonNull).map(FundingLevel::getId).toList(), doc);
        MappingUtils.addField("relfundinglevel1_name", fundingStream.stream().map(Funding::getLevel1).filter(Objects::nonNull).map(FundingLevel::getName).toList(), doc);
        MappingUtils.addField("relfundinglevel2_id", fundingStream.stream().map(Funding::getLevel2).filter(Objects::nonNull).map(FundingLevel::getId).toList(), doc);
        MappingUtils.addField("relfundinglevel2_name", fundingStream.stream().map(Funding::getLevel2).filter(Objects::nonNull).map(FundingLevel::getName).toList(), doc);
        MappingUtils.addField("relfunder", links.stream().filter(rr -> RecordType.project.equals((Object)rr.getHeader().getRelatedRecordType())).flatMap(rr -> Optional.ofNullable(rr.getFunding()).flatMap(funding -> Optional.ofNullable(funding.getFunder()).map(f -> Stream.of(f.getId(), f.getName(), f.getShortname()).filter(StringUtils::isNotBlank).collect(Collectors.joining(DELIMITER)))).stream()).toList(), doc);
        MappingUtils.addField("relfunderid", fundingStream.stream().map(Funding::getFunder).filter(Objects::nonNull).map(Funder::getId).toList(), doc);
        MappingUtils.addField("relfundershortname", fundingStream.stream().map(Funding::getFunder).filter(Objects::nonNull).map(Funder::getShortname).toList(), doc);
        MappingUtils.addField("semrelid", links.stream().map(RelatedRecord::getHeader).map(rh -> new StringJoiner(DELIMITER).add(rh.getRelatedIdentifier()).add(rh.getRelationClass()).toString()).toList(), doc);
    }

    private static List<RelatedRecord> filterLinks(List<RelatedRecord> links, String ... filter) {
        HashSet filterSet = Stream.of(filter).collect(Collectors.toCollection(HashSet::new));
        if (Objects.isNull(links)) {
            return new ArrayList<RelatedRecord>();
        }
        return links.stream().filter(l -> filterSet.contains(l.getHeader().getRelationClass())).toList();
    }

    private static void mapDatasourceFields(SolrInputDocument doc, Datasource d) {
        MappingUtils.addField("datasourceofficialname", d.getOfficialname(), doc);
        MappingUtils.addField("datasourceenglishname", d.getEnglishname(), doc);
        MappingUtils.addField("datasourceoddescription", d.getDescription(), doc);
        MappingUtils.addField("datasourceodlanguages", d.getLanguages(), doc);
        MappingUtils.addField("datasourceodcontenttypes", d.getOdcontenttypes(), doc);
        MappingUtils.addField("datasourcetypename", Optional.ofNullable(d.getDatasourcetype()).map(CodeLabel::getLabel), doc);
        MappingUtils.addField("datasourcetypeuiid", Optional.ofNullable(d.getDatasourcetypeui()).map(CodeLabel::getCode), doc);
        MappingUtils.addField("datasourcetypeuiname", Optional.ofNullable(d.getDatasourcetypeui()).map(CodeLabel::getLabel), doc);
        MappingUtils.addField("datasourcecompatibilityid", Optional.ofNullable(d.getOpenairecompatibility()).map(CodeLabel::getCode), doc);
        MappingUtils.addField("datasourcecompatibilityname", Optional.ofNullable(d.getOpenairecompatibility()).map(CodeLabel::getLabel), doc);
        MappingUtils.addField("datasourcesubjects", Optional.ofNullable(d.getSubjects()).map(s -> s.stream().map(Subject::getValue).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("datasourcejurisdiction", Optional.ofNullable(d.getJurisdiction()).map(CodeLabel::getLabel), doc);
        MappingUtils.addField("datasourcethematic", Optional.ofNullable(d.getThematic()).map(Object::toString), doc);
        MappingUtils.addField("eosctype", Optional.ofNullable(d.getEosctype()).map(CodeLabel::getLabel), doc);
        MappingUtils.addField("eoscdatasourcetype", Optional.ofNullable(d.getEoscdatasourcetype()).map(CodeLabel::getLabel), doc);
    }

    private static void mapOrganizationFields(SolrInputDocument doc, Organization o, List<RelatedRecord> links) {
        MappingUtils.addField("organizationdupid", links.stream().map(RelatedRecord::getHeader).map(RelatedRecordHeader::getRelatedIdentifier).toList(), doc);
        MappingUtils.addField("organizationlegalshortname", Collections.singletonList(o.getLegalshortname()), links.stream().map(RelatedRecord::getLegalshortname).toList(), doc);
        MappingUtils.addField("organizationlegalname", Collections.singletonList(o.getLegalshortname()), links.stream().map(RelatedRecord::getLegalname).toList(), doc);
        MappingUtils.addField("organizationalternativenames", o.getLegalshortname(), doc);
    }

    private static void mapProjectFields(SolrInputDocument doc, Project p) {
        MappingUtils.addField("projectcode", p.getCode(), doc);
        MappingUtils.addField("projectcode_nt", p.getCode(), doc);
        MappingUtils.addField("projectacronym", p.getAcronym(), doc);
        MappingUtils.addField("projecttitle", p.getTitle(), doc);
        MappingUtils.addField("projecttitle_alternative", p.getTitle(), doc);
        MappingUtils.addField("projectstartdate", Optional.ofNullable(p.getStartdate()).map(MappingUtils::normalizeDate), doc);
        MappingUtils.addField("projectstartyear", Optional.ofNullable(p.getStartdate()).map(MappingUtils::normalizeDate).map(MappingUtils::extractYear), doc);
        MappingUtils.addField("projectenddate", Optional.ofNullable(p.getEnddate()).map(MappingUtils::normalizeDate), doc);
        MappingUtils.addField("projectendyear", Optional.ofNullable(p.getEnddate()).map(MappingUtils::normalizeDate).map(MappingUtils::extractYear), doc);
        MappingUtils.addField("projectcallidentifier", p.getCallidentifier(), doc);
        MappingUtils.addField("projectduration", p.getDuration(), doc);
        MappingUtils.addField("projectkeywords", p.getKeywords(), doc);
        MappingUtils.addField("projectoamandatepublications", p.getOamandatepublications(), doc);
        Optional<FundingLevel> fundingL0 = Optional.ofNullable(p.getFunding()).map(Funding::getLevel0);
        MappingUtils.addField("fundinglevel0_id", fundingL0.map(FundingLevel::getId), doc);
        MappingUtils.addField("fundinglevel0_name", fundingL0.map(FundingLevel::getName), doc);
        MappingUtils.addField("fundinglevel0_description", fundingL0.map(FundingLevel::getDescription), doc);
        Optional<FundingLevel> fundingL1 = Optional.ofNullable(p.getFunding()).map(Funding::getLevel1);
        MappingUtils.addField("fundinglevel1_id", fundingL1.map(FundingLevel::getId), doc);
        MappingUtils.addField("fundinglevel1_name", fundingL1.map(FundingLevel::getName), doc);
        MappingUtils.addField("fundinglevel1_description", fundingL1.map(FundingLevel::getDescription), doc);
        Optional<FundingLevel> fundingL2 = Optional.ofNullable(p.getFunding()).map(Funding::getLevel2);
        MappingUtils.addField("fundinglevel2_id", fundingL2.map(FundingLevel::getId), doc);
        MappingUtils.addField("fundinglevel2_name", fundingL2.map(FundingLevel::getName), doc);
        MappingUtils.addField("fundinglevel2_description", fundingL2.map(FundingLevel::getDescription), doc);
        Optional<Funder> funder = Optional.ofNullable(p.getFunding()).map(Funding::getFunder);
        MappingUtils.addField("funderid", funder.map(Funder::getId), doc);
        MappingUtils.addField("fundershortname", funder.map(Funder::getShortname), doc);
        MappingUtils.addField("funder", new StringJoiner(DELIMITER).add(funder.map(Funder::getId).orElse(null)).add(funder.map(Funder::getName).orElse(null)).add(funder.map(Funder::getShortname).orElse(null)).toString(), doc);
    }

    private static String mapToOafType(RecordType recordType) {
        switch (recordType) {
            case publication: 
            case dataset: 
            case software: 
            case other: {
                return "result";
            }
            case datasource: {
                return "datasource";
            }
            case organization: {
                return "organization";
            }
            case project: {
                return "project";
            }
            case person: {
                return "person";
            }
        }
        throw new IllegalArgumentException("invalid");
    }

    private static void mapResultFields(SolrInputDocument doc, Result r, List<RelatedRecord> links) {
        List<RelatedRecord> merges = SolrInputDocumentMapper.filterLinks(links, "merges");
        MappingUtils.addField("resultdupid", merges.stream().map(RelatedRecord::getHeader).map(RelatedRecordHeader::getRelatedIdentifier).toList(), doc);
        MappingUtils.addField("resulttitle", r.getMaintitle(), merges.stream().map(RelatedRecord::getTitle).toList(), doc);
        MappingUtils.addField("resultsubject", Optional.ofNullable(r.getSubject()).map(s -> s.stream().map(Subject::getValue).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("resultembargoenddate", Optional.ofNullable(r.getEmbargoenddate()).map(MappingUtils::normalizeDate), doc);
        MappingUtils.addField("resultembargoendyear", Optional.ofNullable(r.getEmbargoenddate()).map(MappingUtils::normalizeDate).map(MappingUtils::extractYear), doc);
        MappingUtils.addField("resulttypeid", r.getResulttype(), doc);
        MappingUtils.addField("resultlanguagename", Optional.ofNullable(r.getLanguage()).map(Language::getLabel), doc);
        MappingUtils.addField("resultpublisher", r.getPublisher(), doc);
        MappingUtils.addField("resultdescription", r.getDescription(), doc);
        MappingUtils.addField("resultbestaccessright", Optional.ofNullable(r.getBestaccessright()).map(BestAccessRight::getLabel), doc);
        MappingUtils.addField("resultdateofacceptance", Optional.ofNullable(r.getPublicationdate()).map(MappingUtils::normalizeDate), doc);
        MappingUtils.addField("resultacceptanceyear", Optional.ofNullable(r.getPublicationdate()).map(MappingUtils::normalizeDate).map(MappingUtils::extractYear), doc);
        MappingUtils.addField("resultauthor", Optional.ofNullable(r.getAuthor()).map(a -> a.stream().map(Author::getFullname).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("authorid", Optional.ofNullable(r.getAuthor()).map(authors -> authors.stream().map(a -> Optional.ofNullable(a.getPid()).stream().flatMap(pids -> pids.stream().map(Pid::getValue))).flatMap(p -> p.toList().stream()).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("orcidtypevalue", Optional.ofNullable(r.getAuthor()).stream().flatMap(authors -> authors.stream().flatMap(a -> Optional.ofNullable(a.getPid()).stream().flatMap(pids -> pids.stream().filter(p -> "orcid".equals(p.getTypeCode()) || "orcid_pending".equals(p.getTypeCode())).map(p -> new StringJoiner(DELIMITER).add(p.getValue()).add(p.getTypeCode()).toString())))).toList(), doc);
        MappingUtils.addField("resulthostingdatasource", Optional.ofNullable(r.getInstance()).map(instances -> instances.stream().flatMap(i -> Optional.ofNullable(i.getHostedby()).map(hb -> new StringJoiner(DELIMITER).add(hb.getDsId()).add(hb.getDsName()).toString()).stream()).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("resulthostingdatasourceid", Optional.ofNullable(r.getInstance()).map(instances -> instances.stream().flatMap(i -> Optional.ofNullable(i.getHostedby()).map(Provenance::getDsId).stream()).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("collectedfromname", Optional.ofNullable(r.getInstance()).map(instances -> instances.stream().flatMap(i -> Optional.ofNullable(i.getCollectedfrom()).map(Provenance::getDsName).stream()).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("collectedfromdatasourceid", Optional.ofNullable(r.getInstance()).map(instances -> instances.stream().flatMap(i -> Optional.ofNullable(i.getCollectedfrom()).map(Provenance::getDsId).stream()).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("instancetypename", Optional.ofNullable(r.getInstance()).map(instances -> instances.stream().flatMap(i -> Optional.ofNullable(i.getInstancetype()).stream()).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("externalreflabel", Optional.ofNullable(r.getExternalReference()).map(e -> e.stream().map(ExternalReference::getLabel).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("resultidentifier", Optional.ofNullable(r.getInstance()).map(instances -> instances.stream().flatMap(i -> Stream.ofNullable(i.getUrl()).flatMap(Collection::stream)).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("resultsource", r.getSource(), doc);
        MappingUtils.addField("isgreen", Optional.ofNullable(r.getIsGreen()).map(Objects::toString), doc);
        MappingUtils.addField("openaccesscolor", Optional.ofNullable(r.getOpenAccessColor()).map(Enum::toString), doc);
        MappingUtils.addField("isindiamondjournal", Optional.ofNullable(r.getIsInDiamondJournal()).map(Objects::toString), doc);
        MappingUtils.addField("publiclyfunded", Optional.ofNullable(r.getPubliclyFunded()).map(Objects::toString), doc);
        MappingUtils.addField("peerreviewed", Optional.ofNullable(r.getInstance()).map(inst -> inst.stream().anyMatch(i -> "peerReviewed".equals(i.getRefereed()))).map(Objects::toString), doc);
        MappingUtils.addField("haslicense", Optional.ofNullable(r.getInstance()).map(inst -> inst.stream().anyMatch(i -> StringUtils.isNotEmpty((CharSequence)i.getLicense()))).map(Objects::toString), doc);
        MappingUtils.addField("eoscifguidelines", Optional.ofNullable(r.getEoscifguidelines()).map(e -> e.stream().map(EoscIfGuidelines::getCode).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("fos", Optional.ofNullable(r.getSubject()).map(s -> s.stream().filter(ss -> "FOS".equals(ss.getTypeCode())).map(Subject::getValue).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("foslabel", Optional.ofNullable(r.getSubject()).map(s -> s.stream().filter(ss -> "FOS".equals(ss.getTypeCode())).map(ss -> new StringJoiner(DELIMITER).add(ss.getValue()).add(ss.getValue().replaceFirst("^\\d+\\s", "")).toString()).toList()).orElse(new ArrayList()), doc);
        MappingUtils.addField("sdg", Optional.ofNullable(r.getSubject()).map(s -> s.stream().filter(ss -> "SDG".equals(ss.getTypeCode())).map(Subject::getValue).toList()).orElse(new ArrayList()), doc);
        List resultCountries = Optional.ofNullable(r.getCountry()).stream().flatMap(countries -> countries.stream().map(Country::getCode)).toList();
        List orgCountries = SolrInputDocumentMapper.filterLinks(links, "hasAuthorInstitution").stream().flatMap(rr -> Optional.ofNullable(rr.getCountry()).map(Country::getCode).stream()).toList();
        MappingUtils.addField("country", Stream.concat(Stream.concat(resultCountries.stream(), orgCountries.stream()), SolrInputDocumentMapper.filterLinks(links, "isProducedBy").stream().flatMap(rr -> Optional.ofNullable(rr.getFunding()).flatMap(f -> Optional.ofNullable(f.getFunder()).flatMap(funder -> Optional.ofNullable(funder.getJurisdiction()).map(Country::getCode))).stream())).toList(), doc);
        MappingUtils.addField("countrynojurisdiction", Stream.concat(resultCountries.stream(), orgCountries.stream()).toList(), doc);
    }
}

