/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholix.api.controller;

import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.dhp.schema.sx.api.model.v2.PageResultType;
import eu.dnetlib.dhp.schema.sx.api.model.v2.ScholixType;
import eu.dnetlib.scholix.api.ScholixException;
import eu.dnetlib.scholix.api.index.ScholixIndexManager;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2"})
@Tag(name="Links : Operation related to the Scholix Links")
public class ScholixControllerV2
extends AbstractDnetController {
    @Autowired
    private ScholixIndexManager manager;

    @Timed(value="scholix.v2.links", description="Time taken to return links on Version 2.0 of Scholix")
    @Operation(summary="Get Scholix Links")
    @GetMapping(value={"/Links"})
    public PageResultType links(@RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships collected from a LinkProvider") String linkProvider, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a target pid") String targetPid, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a target pid type") String targetPidType, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a target published in a Publisher named targetPublisher") String targetPublisher, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a target type (literature, dataset, unknown)") String targetType, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a source pid") String sourcePid, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a source pid type") String sourcePidType, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a source published in a Publisher named sourcePublisher") String sourcePublisher, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a source type (literature, dataset, unknown)") String sourceType, @Parameter(in=ParameterIn.QUERY, description="select page of result") Integer page) throws Exception {
        if (StringUtils.isEmpty((CharSequence)sourcePid) && StringUtils.isEmpty((CharSequence)targetPid) && StringUtils.isEmpty((CharSequence)sourcePublisher) && StringUtils.isEmpty((CharSequence)targetPublisher) && StringUtils.isEmpty((CharSequence)sourceType) && StringUtils.isEmpty((CharSequence)linkProvider)) {
            throw new ScholixException("The method requires one of the following parameters: sourcePid, targetPid, sourcePublisher, targetPublisher, linkProvider, sourceType");
        }
        try {
            int currentPage = page != null ? page : 0;
            Pair scholixResult = this.manager.linksFromPid(linkProvider, targetPid, targetPidType, targetPublisher, targetType, sourcePid, sourcePidType, sourcePublisher, sourceType, Integer.valueOf(currentPage));
            PageResultType pageResult = new PageResultType();
            pageResult.setTotalPages(Integer.valueOf(((Long)scholixResult.getLeft()).intValue() / 10));
            pageResult.setTotalLinks(Integer.valueOf(((Long)scholixResult.getLeft()).intValue()));
            pageResult.setResult(((List)scholixResult.getRight()).stream().map(ScholixType::fromScholix).collect(Collectors.toList()));
            return pageResult;
        }
        catch (Throwable e) {
            throw new ScholixException("Error on requesting url ", e);
        }
    }
}

