/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.index;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import eu.dnetlib.dhp.schema.sx.scholix.flat.ScholixFlat;
import eu.dnetlib.scholexplorer.api.ScholixException;
import eu.dnetlib.scholexplorer.api.TaggedCounter;
import eu.dnetlib.scholexplorer.api.index.ElasticSearchPool;
import eu.dnetlib.scholexplorer.api.index.ElasticSearchProperties;
import eu.dnetlib.scholexplorer.api.index.ScholixIndexManager;
import eu.dnetlib.scholexplorer.api.model.KPIMetric;
import eu.dnetlib.scholexplorer.api.model.Summary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class ScholixIndexManager {
    @Autowired
    ElasticSearchProperties elasticSearchProperties;
    @Autowired
    ElasticSearchPool connectionPool;
    final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    TaggedCounter myCounter;

    private List<String> extractIdentifiersFromScholix(SearchHits<ScholixFlat> scholix) {
        return scholix.stream().flatMap(s -> Stream.of(((ScholixFlat)s.getContent()).getSourceId(), ((ScholixFlat)s.getContent()).getTargetId())).distinct().toList();
    }

    private Map<String, ScholixResource> retrieveResources(ElasticsearchRestTemplate client, List<String> ids) {
        IdsQueryBuilder qb = new IdsQueryBuilder().addIds((String[])ids.toArray(String[]::new));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)qb).withPageable((Pageable)PageRequest.of((int)0, (int)ids.size())).build();
        SearchHits result = client.search((Query)searchQuery, Summary.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexResourceName()}));
        return result.stream().map(r -> {
            try {
                return (ScholixResource)this.mapper.readValue(((Summary)r.getContent()).getData(), ScholixResource.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(ScholixResource::getDnetIdentifier, v -> v, (a, b) -> a));
    }

    private Scholix generateScholix(ScholixFlat flat, ScholixResource source, ScholixResource target) throws ScholixException {
        if (flat == null || source == null || target == null) {
            throw new ScholixException("Error generating scholix null input");
        }
        Scholix scholix = new Scholix();
        scholix.setSource(source);
        scholix.setTarget(target);
        scholix.setIdentifier(flat.getIdentifier());
        ScholixRelationship r = new ScholixRelationship();
        r.setSchema("datacite");
        r.setName(flat.getRelationType().toLowerCase());
        scholix.setRelationship(r);
        scholix.setPublicationDate(flat.getPublicationDate());
        scholix.setLinkprovider(flat.getLinkProviders().stream().map(p -> {
            ScholixEntityId eid = new ScholixEntityId();
            eid.setName(p);
            return eid;
        }).toList());
        HashMap publishers = new HashMap();
        if (source.getPublisher() != null) {
            source.getPublisher().forEach(p -> publishers.put(p.getName(), p));
        }
        if (target.getPublisher() != null) {
            target.getPublisher().forEach(p -> publishers.put(p.getName(), p));
        }
        scholix.setPublisher(publishers.values().stream().toList());
        return scholix;
    }

    private QueryBuilder createFinalQuery(List<QueryBuilder> queries) throws ScholixException {
        if (queries == null || queries.isEmpty()) {
            throw new ScholixException("the list of queries must be not empty");
        }
        if (queries.size() == 1) {
            return queries.get(0);
        }
        BoolQueryBuilder b = new BoolQueryBuilder();
        b.must().addAll(queries);
        return b;
    }

    public List<Pair<String, Long>> totalLinksByProvider(String filterName) throws ScholixException {
        MatchAllQueryBuilder query = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filterName}) ? QueryBuilders.termQuery((String)"linkProviders", (String)filterName) : QueryBuilders.matchAllQuery();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)query).withSearchType(SearchType.DEFAULT).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation((AbstractAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"genres").field("linkProviders")).size(100).minDocCount(1L)).build();
        Pair resource = null;
        try {
            resource = (Pair)this.connectionPool.getResource();
            ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
            SearchHits hits = client.search((Query)searchQuery, ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            Aggregations aggregations = hits.getAggregations();
            if (aggregations == null) {
                List<Pair<String, Long>> list = null;
                return list;
            }
            List<Pair<String, Long>> list = ((ParsedStringTerms)aggregations.get("genres")).getBuckets().stream().map(b -> new ImmutablePair((Object)b.getKeyAsString(), (Object)b.getDocCount())).collect(Collectors.toList());
            return list;
        }
        catch (ScholixException e) {
            throw e;
        }
        finally {
            if (this.connectionPool != null) {
                this.connectionPool.returnResource((Object)resource);
            }
        }
    }

    private QueryBuilder createLinkPublisherQuery(RelationPrefix prefix, String publisher) throws ScholixException {
        if (prefix == null) {
            throw new ScholixException("prefix cannot be null");
        }
        return new NestedQueryBuilder(String.format("%s.publisher", prefix), (QueryBuilder)new TermQueryBuilder(String.format("%s.publisher.name", prefix), publisher), ScoreMode.None);
    }

    public KPIMetric getKPI() throws ScholixException {
        ArrayList<CompositeValuesSourceBuilder> sources = new ArrayList<CompositeValuesSourceBuilder>();
        sources.add(new TermsValuesSourceBuilder("relationTypeSource").field("sourceType"));
        sources.add(new TermsValuesSourceBuilder("relationTypeTarget").field("targetType"));
        CompositeAggregationBuilder compositeAggregationBuilder = new CompositeAggregationBuilder("Composite_relationTypes", sources).size(10000);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withSearchType(SearchType.DEFAULT).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation((AbstractAggregationBuilder)compositeAggregationBuilder).build();
        Pair resource = null;
        try {
            resource = (Pair)this.connectionPool.getResource();
            ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
            long total = client.count((Query)new NativeSearchQueryBuilder().withSearchType(SearchType.DEFAULT).build(), ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            long totalItem = client.count((Query)new NativeSearchQueryBuilder().withSearchType(SearchType.DEFAULT).build(), ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexResourceName()}));
            KPIMetric metric = new KPIMetric();
            metric.setNumberOfRelationships(Long.valueOf(total));
            metric.setNumberOfEntity(Long.valueOf(totalItem));
            SearchHits hits = client.search((Query)searchQuery, ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            Aggregations aggregations = hits.getAggregations();
            if (aggregations == null) {
                KPIMetric kPIMetric = null;
                return kPIMetric;
            }
            metric.setRelationMetrics(((ParsedComposite)aggregations.get("Composite_relationTypes")).getBuckets().stream().map(b -> new KPIMetric.ScholixRelMetric(b.getKey().get("relationTypeSource").toString(), b.getKey().get("relationTypeTarget").toString(), b.getDocCount())).toList());
            KPIMetric kPIMetric = metric;
            return kPIMetric;
        }
        catch (ScholixException e) {
            throw e;
        }
        finally {
            if (this.connectionPool != null) {
                this.connectionPool.returnResource((Object)resource);
            }
        }
    }

    public List<Pair<String, Long>> totalLinksPublisher(RelationPrefix prefix, String filterName) throws ScholixException {
        MatchAllQueryBuilder query = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filterName}) ? this.createLinkPublisherQuery(prefix, filterName) : QueryBuilders.matchAllQuery();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)query).withSearchType(SearchType.DEFAULT).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation((AbstractAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"publishers").field(String.format("%sPublisher", prefix.toString()))).size(100).minDocCount(1L)).build();
        Pair resource = null;
        try {
            resource = (Pair)this.connectionPool.getResource();
            ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
            SearchHits hits = client.search((Query)searchQuery, ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            Aggregations aggregations = hits.getAggregations();
            if (aggregations == null) {
                List<Pair<String, Long>> list = null;
                return list;
            }
            List<Pair<String, Long>> list = ((ParsedStringTerms)aggregations.get("publishers")).getBuckets().stream().map(b -> new ImmutablePair((Object)b.getKeyAsString(), (Object)b.getDocCount())).collect(Collectors.toList());
            return list;
        }
        catch (ScholixException e) {
            throw e;
        }
        finally {
            if (this.connectionPool != null) {
                this.connectionPool.returnResource((Object)resource);
            }
        }
    }

    private void incrementPidCounter(RelationPrefix prefix, String value) {
        switch (value.toLowerCase()) {
            case "doi": {
                this.myCounter.increment(String.format("%s_doi", prefix));
                break;
            }
            case "pmc": {
                this.myCounter.increment(String.format("%s_pmc", prefix));
                break;
            }
            default: {
                this.myCounter.increment(String.format("%s_other", prefix));
            }
        }
    }

    public Pair<Long, List<Scholix>> linksToOpenAIREId(String sourceId, Integer page) throws ScholixException {
        ArrayList<TermQueryBuilder> queries = new ArrayList<TermQueryBuilder>();
        queries.add(QueryBuilders.termQuery((String)"sourceId", (String)sourceId));
        QueryBuilder result = this.createFinalQuery(queries);
        NativeSearchQuery finalQuery = new NativeSearchQueryBuilder().withQuery(result).withPageable((Pageable)PageRequest.of((int)page, (int)100)).build();
        Pair resource = null;
        try {
            resource = (Pair)this.connectionPool.getResource();
            ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
            long tt = client.count((Query)finalQuery, ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            SearchHits scholixRes = client.search((Query)finalQuery, ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            if (tt > 0L) {
                Map idMap = this.retrieveResources(client, this.extractIdentifiersFromScholix(scholixRes));
                ImmutablePair immutablePair = new ImmutablePair((Object)tt, scholixRes.stream().map(SearchHit::getContent).map(s -> {
                    try {
                        return this.generateScholix(s, (ScholixResource)idMap.get(s.getSourceId()), (ScholixResource)idMap.get(s.getTargetId()));
                    }
                    catch (ScholixException e) {
                        throw new RuntimeException(e);
                    }
                }).toList());
                return immutablePair;
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)tt, new ArrayList());
            return immutablePair;
        }
        catch (ScholixException e) {
            throw e;
        }
        finally {
            if (this.connectionPool != null) {
                this.connectionPool.returnResource((Object)resource);
            }
        }
    }

    public Pair<Long, List<Scholix>> linksFromPid(String linkProvider, String targetPid, String targetPidType, String targetPublisher, String targetType, String sourcePid, String sourcePidType, String sourcePublisher, String sourceType, String relation, String fromDate, String toDate, Integer page) throws ScholixException {
        BoolQueryBuilder b;
        if (sourcePid == null && sourcePidType == null && sourceType == null && targetType == null && targetPid == null && targetPidType == null && sourcePublisher == null && targetPublisher == null && linkProvider == null) {
            throw new ScholixException("One of sourcePid, targetPid, sourcePublisher, targetPublisher, linkProvider should be not null");
        }
        ArrayList<Object> queries = new ArrayList<Object>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{linkProvider})) {
            this.myCounter.increment("linkProvider");
            queries.add(QueryBuilders.matchQuery((String)"linkProviders", (Object)linkProvider));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetPid})) {
            this.myCounter.increment("targetPid");
            b = new BoolQueryBuilder();
            b.should().addAll(List.of(QueryBuilders.termQuery((String)"targetPid", (String)targetPid), QueryBuilders.termQuery((String)"targetId", (String)targetPid)));
            queries.add(b);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourcePid})) {
            this.myCounter.increment("sourcePid");
            b = new BoolQueryBuilder();
            b.should().addAll(List.of(QueryBuilders.termQuery((String)"sourcePid", (String)sourcePid), QueryBuilders.termQuery((String)"sourceId", (String)sourcePid)));
            queries.add(b);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetPidType})) {
            assert (targetPidType != null);
            this.incrementPidCounter(RelationPrefix.target, targetPidType);
            queries.add(QueryBuilders.termQuery((String)"targetPidType", (String)targetPidType));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourcePidType})) {
            assert (sourcePidType != null);
            this.incrementPidCounter(RelationPrefix.source, sourcePidType);
            queries.add(QueryBuilders.termQuery((String)"sourcePidType", (String)sourcePidType));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetType})) {
            this.myCounter.increment(String.format("targetType_%s", targetType));
            queries.add(QueryBuilders.termQuery((String)"targetType", (String)targetType));
        }
        if (StringUtils.isNotBlank((CharSequence)fromDate)) {
            queries.add(QueryBuilders.rangeQuery((String)"publicationDate").gte((Object)fromDate));
        }
        if (StringUtils.isNotBlank((CharSequence)toDate)) {
            queries.add(QueryBuilders.rangeQuery((String)"publicationDate").lte((Object)toDate));
        }
        if (StringUtils.isNotBlank((CharSequence)sourceType)) {
            this.myCounter.increment(String.format("sourceType_%s", sourceType));
            queries.add(QueryBuilders.termQuery((String)"sourceType", (String)sourceType));
        }
        if (StringUtils.isNotBlank((CharSequence)targetPublisher)) {
            this.myCounter.increment("targetPublisher");
            queries.add(QueryBuilders.matchQuery((String)"targetPublisher", (Object)targetPublisher));
        }
        if (StringUtils.isNotBlank((CharSequence)sourcePublisher)) {
            this.myCounter.increment("sourcePublisher");
            queries.add(QueryBuilders.matchQuery((String)"sourcePublisher", (Object)sourcePublisher));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{relation})) {
            this.myCounter.increment("relationType");
            queries.add(QueryBuilders.termQuery((String)"relationType", (String)relation));
        }
        QueryBuilder result = this.createFinalQuery(queries);
        NativeSearchQuery finalQuery = new NativeSearchQueryBuilder().withQuery(result).withPageable((Pageable)PageRequest.of((int)page, (int)100)).build();
        Pair resource = null;
        try {
            resource = (Pair)this.connectionPool.getResource();
            ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
            long tt = client.count((Query)finalQuery, ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            SearchHits scholixRes = client.search((Query)finalQuery, ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            if (tt > 0L) {
                Map idMap = this.retrieveResources(client, this.extractIdentifiersFromScholix(scholixRes));
                ImmutablePair immutablePair = new ImmutablePair((Object)tt, scholixRes.stream().map(SearchHit::getContent).map(s -> {
                    try {
                        return this.generateScholix(s, (ScholixResource)idMap.get(s.getSourceId()), (ScholixResource)idMap.get(s.getTargetId()));
                    }
                    catch (ScholixException e) {
                        throw new RuntimeException(e);
                    }
                }).toList());
                return immutablePair;
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)tt, new ArrayList());
            return immutablePair;
        }
        catch (ScholixException e) {
            throw e;
        }
        finally {
            if (this.connectionPool != null) {
                this.connectionPool.returnResource((Object)resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Scholix> findPage(String relType) throws ScholixException {
        Pair resource = null;
        try {
            resource = (Pair)this.connectionPool.getResource();
            ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.termQuery((String)"relationType", (String)relType)).withSearchType(SearchType.DEFAULT).withPageable((Pageable)PageRequest.of((int)0, (int)20)).build();
            SearchHits search = client.search((Query)searchQuery, ScholixFlat.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
            Map idMap = this.retrieveResources(client, this.extractIdentifiersFromScholix(search));
            List<Scholix> list = search.stream().map(SearchHit::getContent).map(s -> {
                try {
                    return this.generateScholix(s, (ScholixResource)idMap.get(s.getSourceId()), (ScholixResource)idMap.get(s.getTargetId()));
                }
                catch (ScholixException e) {
                    throw new RuntimeException(e);
                }
            }).toList();
            return list;
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (this.connectionPool != null && resource != null) {
                this.connectionPool.returnResource((Object)resource);
            }
        }
        return null;
    }
}

